/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.base;

import java.io.File;
import java.io.FileInputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;

public class MD5Util {
    public static final String FILE_HASH_MD5 = "MD5";
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static String md5Digest(byte[] inputBytes) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance(FILE_HASH_MD5);
        md5.reset();
        md5.update(inputBytes);
        return MD5Util.toHexString(md5.digest());
    }

    public static String md5Digest(String input) throws Exception {
        return MD5Util.md5Digest(input.getBytes(DEFAULT_CHARSET));
    }

    public static String md5Digest(File file) throws Exception {
        FileInputStream in = new FileInputStream(file);
        FileChannel ch = in.getChannel();
        MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        MessageDigest md5 = MessageDigest.getInstance(FILE_HASH_MD5);
        md5.reset();
        md5.update(byteBuffer);
        return MD5Util.toHexString(md5.digest());
    }

    public static String toHexString(byte[] b) {
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int val = b[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString().toUpperCase();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(MD5Util.md5Digest(new File("h:/slipper1.zip")));
    }
}

