/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.decoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.AESUtils;
import netbank.firm.decoder.DcfirmMessageToMessageDecoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;

public class DecryptDecoder
extends DcfirmMessageToMessageDecoder<Message> {
    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                MessageHead mh = (MessageHead)msg.getHead();
                if (mh.getEncrypt().booleanValue()) {
                    this.LOG.debug("\u89e3\u5bc6\u5904\u7406" + mh.getKey());
                    msg.setBody(AESUtils.decrypt(mh.getKey().getBytes(), msg.getBody()));
                    msg.getHead().setLength(msg.getBody().length);
                } else {
                    this.LOG.debug("\u65e0\u9700\u89e3\u5bc6\u5904\u7406");
                }
            }
            out.add(msg);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U110, (Throwable)e);
        }
    }
}

