/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.encoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.AESUtils;
import netbank.firm.encoder.DcfirmMessageToMessageEncoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;

public class EncryptEncoder
extends DcfirmMessageToMessageEncoder<Message> {
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                MessageHead mh = (MessageHead)msg.getHead();
                if (mh.getEncrypt().booleanValue()) {
                    this.LOG.debug("\u52a0\u5bc6\u5904\u7406" + mh.getKey());
                    msg.setBody(AESUtils.encrypt(mh.getKey().getBytes(), msg.getBody()));
                    msg.getHead().setLength(msg.getBody().length);
                } else {
                    this.LOG.debug("\u65e0\u9700\u52a0\u5bc6\u5904\u7406");
                }
            }
            out.add(msg);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U109, (Throwable)e);
        }
    }
}

