/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.file;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import netbank.firm.file.EnCode64;
import org.apache.commons.lang.StringUtils;

public class SimpleIDGenerator {
    private static String _KEY_HOSTNAME = "hostAlias";

    public static String getSerialID(String machineid) throws Exception {
        return machineid + SimpleIDGenerator.getSystemTimeIdentifier() + SimpleIDGenerator.getSystemRandomNum();
    }

    public static String getSerialID() throws Exception {
        String seriaNum = SimpleIDGenerator.getMachineIdentifier() + SimpleIDGenerator.getSystemTimeIdentifier() + SimpleIDGenerator.getSystemRandomNum();
        return seriaNum;
    }

    private static String getMachineIdentifier() throws UnknownHostException {
        String machineId = System.getProperty(_KEY_HOSTNAME);
        if (StringUtils.isEmpty((String)machineId)) {
            String hn = InetAddress.getLocalHost().getHostName();
            if (StringUtils.isNotEmpty((String)hn)) {
                machineId = hn.substring(hn.length() < 2 ? 0 : hn.length() - 2);
            }
        } else {
            machineId = machineId.substring(machineId.length() < 2 ? 0 : machineId.length() - 2);
        }
        machineId = StringUtils.leftPad((String)machineId, (int)2, (String)"x");
        return machineId;
    }

    private static String getSystemTimeIdentifier() throws Exception {
        long time = System.currentTimeMillis();
        if (time >= 0x1000000000L && time < 0x40000000000L) {
            return EnCode64.compressNumber(time);
        }
        throw new Exception("\u65f6\u95f4\u6233\u8d85\u8fc7\u5141\u8bb8\u8303\u56f4\u301068719476736l\u81f34398046511104\u3011");
    }

    private static String getSystemRandomNum() {
        StringBuffer sbf = new StringBuffer(3);
        for (int i = 0; i < 3; ++i) {
            Random random = new Random();
            int randomNum = random.nextInt(64);
            sbf.append(EnCode64.compressNumber(randomNum));
        }
        return sbf.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(SimpleIDGenerator.getSerialID());
    }
}

