/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import netbank.firm.base.GzipUtil;
import netbank.firm.base.MD5Util;
import netbank.firm.exception.DcfirmException;
import netbank.firm.file.FileUtils;
import netbank.firm.handler.AuthProcess;
import netbank.firm.model.DownloadErrorResponse;
import netbank.firm.model.DownloadRequest;
import netbank.firm.model.FileBlockErrorResponse;
import netbank.firm.model.FileBlockResponse;
import netbank.firm.model.FileRequest;
import netbank.firm.model.FileRequestType;
import netbank.firm.model.FileStaticErrorResponse;
import netbank.firm.model.FileStaticRequest;
import netbank.firm.model.FileStaticResponse;
import netbank.firm.model.UploadErrorResponse;
import netbank.firm.model.UploadRequest;
import netbank.firm.model.UploadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFileHandler
extends SimpleChannelInboundHandler<FileRequest<?>> {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final Logger macLog = LoggerFactory.getLogger((String)"filemac.out");
    private File recvFile;
    private RandomAccessFile fos;
    private int blockNums;
    private int lastBlockSize;
    private int blockId;
    private String path;
    private Boolean compress = new Boolean(true);
    private String fileMd;
    private AuthProcess authProcess;
    private String ncid;
    private long maxSize = 0xF00000L;

    public RequestFileHandler(String resvPath, AuthProcess authProcess, long maxSize) {
        this.path = resvPath;
        this.authProcess = authProcess;
        this.maxSize = maxSize;
    }

    public RequestFileHandler(String resvPath, AuthProcess authProcess) {
        this.path = resvPath;
        this.authProcess = authProcess;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FileRequest<?> msg) throws Exception {
        this.ncid = msg.getNcid();
        if (FileRequestType.DATA == msg.getFileRequestType()) {
            this.LOG.info("\u7ba1\u9053id\uff1a" + ctx.channel().id() + "\u54cd\u5e94\u7c7b\u578b\uff1a" + (Object)((Object)msg.getFileRequestType()));
        } else {
            this.LOG.info("\u7ba1\u9053id\uff1a" + ctx.channel().id() + "\u5ba2\u6237\u53f7\uff1a" + this.ncid + "\u54cd\u5e94\u7c7b\u578b\uff1a" + (Object)((Object)msg.getFileRequestType()));
        }
        switch (msg.getFileRequestType()) {
            case UPLOAD: {
                try {
                    UploadRequest request = (UploadRequest)msg;
                    this.authProcess.auth(request);
                    AttributeKey ak = AttributeKey.valueOf((String)"authStatus");
                    ctx.channel().attr(ak).set((Object)Boolean.TRUE);
                    UploadResponse authRes = new UploadResponse();
                    authRes.setNcid(msg.getNcid());
                    String fileId = FileUtils.generateFileId(request.getBizCode(), this.path);
                    this.LOG.info("\u751f\u6210fileID:" + fileId);
                    authRes.setFileId(fileId);
                    this.writeAndFlush(ctx, authRes);
                }
                catch (IOException e) {
                    UploadErrorResponse authRes = new UploadErrorResponse("\u670d\u52a1\u7aef\u63a5\u6536\u6587\u4ef6IO\u5f02\u5e38");
                    this.writeAndFlush(ctx, authRes);
                    ctx.close();
                }
                catch (DcfirmException e) {
                    UploadErrorResponse authRes = new UploadErrorResponse(e.getErrmsg());
                    this.writeAndFlush(ctx, authRes);
                    ctx.close();
                }
                break;
            }
            case DOWNLOAD: {
                try {
                    DownloadRequest dr = (DownloadRequest)msg;
                    this.LOG.info("\u5ba2\u6237[" + dr.getNcid() + "]\u8bf7\u6c42\u4e0b\u8f7d\u6587\u4ef6id\uff1a" + dr.getFileId() + ",\u6587\u4ef6\u540d\u79f0\uff1a" + dr.getFileName());
                    this.macLog.info("\u5ba2\u6237[" + dr.getNcid() + "]\u8bf7\u6c42\u4e0b\u8f7d\u6587\u4ef6id\uff1a" + dr.getFileId() + ",\u6587\u4ef6\u540d\u79f0\uff1a" + dr.getFileName());
                    File downFile = FileUtils.getFile4Send(this.path, dr.getFileId().trim(), dr.getFileName().trim());
                    if (!downFile.exists()) {
                        throw new Exception("\u8bf7\u6c42\u4e0b\u8f7d\u6587\u4ef6[id:" + dr.getFileId() + ",name:" + dr.getFileName().trim() + "]\u4e0d\u5b58\u5728\u3002");
                    }
                    if (downFile.length() > this.maxSize) {
                        throw new Exception("\u8bf7\u6c42\u4e0b\u8f7d\u6587\u4ef6[id:" + dr.getFileId() + ",name:" + dr.getFileName().trim() + "]\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u503c[" + this.maxSize + "]");
                    }
                    if (this.compress.booleanValue()) {
                        File isCompressFile = new File(downFile.getAbsolutePath() + ".gz");
                        if (!isCompressFile.exists()) {
                            GzipUtil.gzip(downFile.getAbsolutePath());
                        }
                        downFile = new File(downFile.getAbsolutePath() + ".gz");
                    }
                    FileStaticRequest fsr = new FileStaticRequest();
                    fsr.setFileLength((int)downFile.length());
                    fsr.setBlockSize(dr.getBlockSize());
                    fsr.setStartBlockId(dr.getStartNum());
                    if (downFile.getName().length() > 15) {
                        fsr.setFileName(downFile.getName().substring(16));
                    } else {
                        fsr.setFileName(downFile.getName());
                    }
                    fsr.setFileFlag("D");
                    fsr.setFileId(dr.getFileId());
                    fsr.setCompress(this.compress);
                    AttributeKey ak = AttributeKey.valueOf((String)"sendFilePath");
                    ctx.channel().attr(ak).set((Object)downFile.getAbsolutePath());
                    AttributeKey isCompress = AttributeKey.valueOf((String)"isCompress");
                    ctx.channel().attr(isCompress).set((Object)(this.compress == true ? "Y" : "N"));
                    fsr.setFileMd(MD5Util.md5Digest(downFile));
                    this.writeAndFlush(ctx, fsr);
                }
                catch (Exception e) {
                    this.LOG.error("\u5ba2\u6237\u8bf7\u6c42\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
                    DownloadErrorResponse dres = new DownloadErrorResponse(e.getMessage());
                    this.writeAndFlush(ctx, dres);
                    ctx.close();
                }
                break;
            }
            case STATIC: {
                try {
                    int fileLength;
                    FileStaticRequest fsre = (FileStaticRequest)msg;
                    String fileId = fsre.getFileId().trim();
                    String fileName = fsre.getFileName().trim();
                    this.recvFile = FileUtils.getFile4Receive(this.path, fileId, fileName);
                    if ("U".equals(fsre.getFileFlag())) {
                        AttributeKey ak = AttributeKey.valueOf((String)"authStatus");
                        Boolean authStatus = (Boolean)ctx.channel().attr(ak).get();
                        if (authStatus == null || !authStatus.booleanValue()) {
                            throw new Exception("\u975e\u6cd5\u72b6\u6001");
                        }
                    }
                    if ((long)(fileLength = fsre.getFileLength().intValue()) > this.maxSize) {
                        throw new Exception("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u503c");
                    }
                    if (fsre.getStartBlockId() > 1) {
                        if (!this.recvFile.exists()) {
                            throw new Exception("\u65ad\u70b9\u7eed\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
                        }
                        int filelen = (int)this.recvFile.length();
                        if (filelen < fsre.getBlockSize() * (fsre.getStartBlockId() - 1)) {
                            throw new Exception("\u6587\u4ef6\u5757\u4f4d\u7f6e\u4e0d\u5bf9");
                        }
                    }
                    this.fos = new RandomAccessFile(this.recvFile, "rw");
                    this.fos.seek(fsre.getBlockSize() * (fsre.getStartBlockId() - 1));
                    this.ncid = fsre.getNcid();
                    this.blockId = fsre.getStartBlockId();
                    this.blockNums = fsre.getFileLength() / fsre.getBlockSize() + 1;
                    this.lastBlockSize = fsre.getFileLength() % fsre.getBlockSize();
                    if (this.lastBlockSize == 0 && this.blockNums != 1) {
                        --this.blockNums;
                        this.lastBlockSize = fsre.getBlockSize();
                    }
                    this.compress = fsre.getCompress();
                    this.fileMd = fsre.getFileMd();
                    FileStaticResponse fsr = new FileStaticResponse("ok");
                    fsr.setNcid(this.ncid);
                    this.writeAndFlush(ctx, fsr);
                }
                catch (Exception e) {
                    FileStaticErrorResponse fsr = new FileStaticErrorResponse(e.getMessage());
                    this.writeAndFlush(ctx, fsr);
                    ctx.close();
                }
                break;
            }
            case DATA: {
                try {
                    if (this.blockNums > 0) {
                        this.LOG.debug("\u6536\u5230\u6587\u4ef6\u5757:[" + this.blockId + "]");
                        this.fos.write(msg.tobytes());
                        --this.blockNums;
                        ++this.blockId;
                        if (this.blockNums == 0) {
                            String md5 = MD5Util.md5Digest(this.recvFile);
                            if (!this.fileMd.equals(md5)) {
                                FileBlockErrorResponse frr = new FileBlockErrorResponse();
                                this.writeAndFlush(ctx, frr);
                                this.LOG.error("\u6587\u4ef6\u6458\u8981\u6821\u9a8c\u4e0d\u7b26");
                                break;
                            }
                            FileBlockResponse frr = new FileBlockResponse();
                            this.writeAndFlush(ctx, frr);
                            this.LOG.info("\u901a\u8fc7\u6587\u4ef6\u6458\u8981\u6821\u9a8c");
                            if (this.compress.booleanValue()) {
                                GzipUtil.gunzip(this.recvFile.getAbsolutePath());
                                if (this.recvFile.exists()) {
                                    this.LOG.info(this.recvFile.getName());
                                    this.recvFile.delete();
                                }
                            }
                            if (this.fos != null) {
                                this.fos.close();
                            }
                            ctx.close();
                            break;
                        }
                        FileBlockResponse frr = new FileBlockResponse();
                        this.writeAndFlush(ctx, frr);
                        break;
                    }
                    if (this.fos != null) {
                        this.fos.close();
                    }
                    ctx.close();
                    break;
                }
                catch (Exception e) {
                    FileBlockErrorResponse frr = new FileBlockErrorResponse(e.getMessage());
                    frr.setNcid(this.ncid);
                    this.writeAndFlush(ctx, frr);
                    if (this.fos != null) {
                        this.fos.close();
                    }
                    ctx.close();
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.fos != null) {
            this.fos.close();
        }
        ctx.close();
        this.LOG.error(cause.getMessage(), cause);
        super.exceptionCaught(ctx, cause);
    }

    private void writeAndFlush(ChannelHandlerContext ctx, Object obj) {
        ChannelFuture f = ctx.writeAndFlush(obj);
        f.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void setCompress(Boolean compress) {
        this.compress = compress;
    }
}

