/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.serial.tool;

import netbank.firm.model.AbstractMessageHead;
import netbank.firm.model.BizType;
import netbank.firm.model.EncryptKeyModel;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;
import netbank.firm.model.SerializableMessage;
import netbank.firm.model.SimpleHead;
import netbank.firm.serial.HeadType;
import netbank.firm.serial.ReflectSerial;
import netbank.firm.serial.Serialable;

public class MessageWrapper {
    public static Object unwrap(Message message) throws Exception {
        AbstractMessageHead<?> head = message.getHead();
        if (MessageType.MESSAGE == message.getMessageType()) {
            BizType bt = ((MessageHead)head).getBizType();
            return ReflectSerial.bytes2Object(head.getMagicNum(), bt, message.getBody());
        }
        return ReflectSerial.bytes2Object(head.getMagicNum(), null, message.getBody());
    }

    public static Message wrap(SerializableMessage<?> object) throws Exception {
        Message mess = new Message();
        Class<?> cls = Class.forName(object.getClass().getName());
        byte[] body = object.tobytes();
        mess.setBody(body);
        Serialable annoCls = cls.getAnnotation(Serialable.class);
        if (HeadType.Message == annoCls.headType()) {
            MessageHead mh = new MessageHead();
            mh.setCompress(annoCls.outCompress());
            mh.setBizType(annoCls.txnModel().getBt());
            mh.setMagicNum(annoCls.txnModel().getMn());
            mh.setLength(body.length);
            mess.setMessageType(MessageType.MESSAGE);
            mess.setHead(mh);
            if (object instanceof EncryptKeyModel) {
                String key = ((EncryptKeyModel)((Object)object)).getKey();
                if (key != null && !"".equals(key)) {
                    mh.setEncrypt(true);
                    mh.setKey(key);
                } else {
                    mh.setEncrypt(false);
                }
            }
        } else {
            SimpleHead fh = new SimpleHead();
            fh.setMagicNum(annoCls.txnModel().getMn());
            fh.setLength(body.length);
            mess.setMessageType(MessageType.FILE);
            mess.setHead(fh);
        }
        return mess;
    }
}

