/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.crypt.impl;

import com.bocom.api.security.crypt.ApiCryptor;
import com.bocom.api.security.keygen.SM2KeyGen;
import com.bocom.api.utils.Base64;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class SM2Cryptor
implements ApiCryptor {
    @Override
    public String encrypt(String plainText, String sm2PubKeyStr, String charset) {
        ECPublicKeyParameters localECPublicKeyParameters = null;
        PublicKey publicKey = null;
        try {
            publicKey = SM2KeyGen.getPublicKey(sm2PubKeyStr.getBytes(charset));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey localECPublicKey = (BCECPublicKey)publicKey;
            ECParameterSpec localECParameterSpec = localECPublicKey.getParameters();
            ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
            localECPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), localECDomainParameters);
        }
        SM2Engine localSM2Engine = new SM2Engine();
        localSM2Engine.init(true, (CipherParameters)new ParametersWithRandom(localECPublicKeyParameters, new SecureRandom()));
        try {
            byte[] arrayOfByte2 = localSM2Engine.processBlock(plainText.getBytes(), 0, plainText.getBytes().length);
            return Base64.encode(arrayOfByte2);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(String cipherText, String sm2PriKeyStr, String charset) {
        PrivateKey privateKey = null;
        try {
            privateKey = SM2KeyGen.getPrivateKey(sm2PriKeyStr.getBytes(charset));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        byte[] encodedataByte = Base64.decode(cipherText.getBytes());
        SM2Engine localSM2Engine = new SM2Engine();
        BCECPrivateKey sm2PriK = (BCECPrivateKey)privateKey;
        ECParameterSpec localECParameterSpec = sm2PriK.getParameters();
        ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
        ECPrivateKeyParameters localECPrivateKeyParameters = new ECPrivateKeyParameters(sm2PriK.getD(), localECDomainParameters);
        localSM2Engine.init(false, (CipherParameters)localECPrivateKeyParameters);
        try {
            byte[] arrayOfByte3 = localSM2Engine.processBlock(encodedataByte, 0, encodedataByte.length);
            return new String(arrayOfByte3);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        try {
            String charset = "UTF-8";
            KeyPair sm2KeyPair = SM2KeyGen.generateKeyPair();
            byte[] sm2PubKey = SM2KeyGen.getPublicKey(sm2KeyPair);
            byte[] sm2PriKey = SM2KeyGen.getPrivateKey(sm2KeyPair);
            System.out.println("SM2\u516c\u94a5\uff1a" + new String(sm2PubKey, "UTF-8"));
            System.out.println("SM2\u79c1\u94a5\uff1a" + new String(sm2PriKey, "UTF-8"));
            SM2Cryptor sm2Cryptor = new SM2Cryptor();
            String plainText = "bankcomm";
            String cipherText = sm2Cryptor.encrypt(plainText, new String(sm2PubKey, "UTF-8"), "UTF-8");
            System.out.println("\u52a0\u5bc6\u540e\u7684\u5bc6\u6587\uff1a" + cipherText);
            System.out.println("\u89e3\u5bc6\u540e\u7684\u660e\u6587\uff1a" + sm2Cryptor.decrypt(cipherText, new String(sm2PriKey, "UTF-8"), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

