/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.sign.impl;

import com.bocom.api.security.keygen.SM2KeyGen;
import com.bocom.api.security.sign.ApiSignature;
import com.bocom.api.utils.Base64;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.util.encoders.Hex;

public class SM2Signature
implements ApiSignature {
    public static void main(String[] args) throws Exception {
        KeyPair keyPair = SM2Signature.genKey();
        SM2KeyGen sm2 = new SM2KeyGen();
        String k1 = SM2KeyGen.getPriKey(keyPair);
        String k2 = SM2KeyGen.getPubKey(keyPair);
        System.out.println(k1);
        System.out.println(k2);
        String prvKey = "MDBhNGUxOTY4YjgzZWMyZWQ2ZjIzNDliNGUyN2Q4ZGI5ZDBhYmMyYjY1YjUzNjFmOTBhZTQ2NjhiYWIwNzc3ZmRh";
        String pubKey = "MDNhMGViOTZlZWM2ZWIzNDQzYzExZTAyNjVkZjgyNmZmMzYwOTFmNjNlM2E1ZGI3YzBjM2U1ZDdmMzczOWNmODEw";
        SM2Signature sm2sign = new SM2Signature();
        byte[] data = "123test".getBytes();
        String sign = sm2sign.sign(data, k1.getBytes(), "1.2.156.10197.1.501");
        System.out.println("Result:" + sm2sign.verify(data, k2.getBytes(), sign, "1.2.156.10197.1.501"));
        System.out.println("prvKey\u957f\u5ea6" + k1.length());
        System.out.println("pubKey\u957f\u5ea6" + k2.length());
    }

    public static KeyPair genKey() throws Exception {
        ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)new BouncyCastleProvider());
        kpg.initialize(sm2Spec);
        kpg.initialize(sm2Spec, new SecureRandom());
        KeyPair keyPair = kpg.generateKeyPair();
        return keyPair;
    }

    @Override
    public String sign(byte[] data, byte[] privateKey, String algorithm) throws Exception {
        Signature signature = Signature.getInstance(algorithm, (Provider)new BouncyCastleProvider());
        signature.initSign(SM2KeyGen.getPrivateKey(privateKey));
        signature.update(data);
        byte[] signatureValue = signature.sign();
        return Hex.toHexString((byte[])signatureValue);
    }

    @Override
    public boolean verify(byte[] data, byte[] publicKey, String sign, String algorithm) throws Exception {
        Signature signature = Signature.getInstance(algorithm, (Provider)new BouncyCastleProvider());
        signature.initVerify(SM2KeyGen.getPublicKey(publicKey));
        signature.update(data);
        return signature.verify(Hex.decode((String)sign));
    }

    public static String encrypt(String data, PublicKey publicKey) {
        ECPublicKeyParameters localECPublicKeyParameters = null;
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey localECPublicKey = (BCECPublicKey)publicKey;
            ECParameterSpec localECParameterSpec = localECPublicKey.getParameters();
            ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
            localECPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), localECDomainParameters);
        }
        SM2Engine localSM2Engine = new SM2Engine();
        localSM2Engine.init(true, (CipherParameters)new ParametersWithRandom(localECPublicKeyParameters, new SecureRandom()));
        try {
            byte[] arrayOfByte2 = localSM2Engine.processBlock(data.getBytes(), 0, data.getBytes().length);
            return Base64.encode(arrayOfByte2);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String encodedata, PrivateKey privateKey) {
        byte[] encodedataByte = Base64.decode(encodedata.getBytes());
        SM2Engine localSM2Engine = new SM2Engine();
        BCECPrivateKey sm2PriK = (BCECPrivateKey)privateKey;
        ECParameterSpec localECParameterSpec = sm2PriK.getParameters();
        ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
        ECPrivateKeyParameters localECPrivateKeyParameters = new ECPrivateKeyParameters(sm2PriK.getD(), localECDomainParameters);
        localSM2Engine.init(false, (CipherParameters)localECPrivateKeyParameters);
        try {
            byte[] arrayOfByte3 = localSM2Engine.processBlock(encodedataByte, 0, encodedataByte.length);
            return new String(arrayOfByte3);
        }
        catch (InvalidCipherTextException e) {
            throw new RuntimeException(e);
        }
    }
}

