/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.utils;

import com.bocom.api.BocomApiException;
import com.bocom.api.security.digest.ApiDigest;
import com.bocom.api.security.digest.impl.DefaultDigest;
import com.bocom.api.utils.FileItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class BocomDigest {
    private static ApiDigest apiDigest = new DefaultDigest();
    private static final String ALGORITHM = "SHA-256";

    public static String fileDigest(FileItem fileItem) throws BocomApiException {
        try {
            return apiDigest.digest(fileItem.getContent(), ALGORITHM);
        }
        catch (Exception xcp) {
            throw new BocomApiException("apidigest exception.", xcp);
        }
    }

    public static String fileDigest(String filePath) throws BocomApiException, FileNotFoundException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException(filePath);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = apiDigest.digest(fis, ALGORITHM);
            return string;
        }
        catch (Exception xcp) {
            throw new BocomApiException("apidigest exception.", xcp);
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    throw new BocomApiException("apidigest exception.", e);
                }
            }
        }
    }
}

