/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.utils;

import com.bocom.api.BocomApiException;
import com.bocom.api.security.crypt.ApiCryptor;
import com.bocom.api.security.crypt.impl.AESCryptor;
import com.bocom.api.security.crypt.impl.RSACryptor;
import com.bocom.api.security.crypt.impl.SM2Cryptor;
import com.bocom.api.security.crypt.impl.SM4Cryptor;
import com.bocom.api.utils.FileItem;
import com.bocom.api.utils.enums.EncryptType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class BocomEncrypt {
    private static AESCryptor aesCryptor = new AESCryptor();
    private static ApiCryptor rsaCryptor = new RSACryptor();
    private static SM4Cryptor sm4Cryptor = new SM4Cryptor();
    private static SM2Cryptor sm2Cryptor = new SM2Cryptor();

    public static String asyEncryptContent(String content, EncryptType algorithmType, String encryptKey, String charset) throws BocomApiException {
        if (EncryptType.RSA_AND_AES == algorithmType) {
            return rsaCryptor.encrypt(content, encryptKey, charset);
        }
        if (EncryptType.SM2_AND_SM4 == algorithmType) {
            return sm2Cryptor.encrypt(content, encryptKey, charset);
        }
        throw new BocomApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aAlgorithmType=" + (Object)((Object)algorithmType));
    }

    public static String symEncryptContent(String content, EncryptType algorithmType, String encryptKey, String charset) throws BocomApiException {
        if (EncryptType.RSA_AND_AES == algorithmType) {
            return aesCryptor.encrypt(content, encryptKey, charset);
        }
        if (EncryptType.SM2_AND_SM4 == algorithmType) {
            return sm4Cryptor.encrypt(content, encryptKey, charset);
        }
        throw new BocomApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aAlgorithmType=" + (Object)((Object)algorithmType));
    }

    public static String asyDecryptContent(String content, EncryptType algorithmType, String encryptKey, String charset) throws BocomApiException {
        if (EncryptType.RSA_AND_AES == algorithmType) {
            return rsaCryptor.decrypt(content, encryptKey, charset);
        }
        if (EncryptType.SM2_AND_SM4 == algorithmType) {
            return sm2Cryptor.decrypt(content, encryptKey, charset);
        }
        throw new BocomApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aAlgorithmType=" + (Object)((Object)algorithmType));
    }

    public static String symDecryptContent(String content, EncryptType algorithmType, String encryptKey, String charset) throws BocomApiException {
        if (EncryptType.RSA_AND_AES == algorithmType) {
            return aesCryptor.decrypt(content, encryptKey, charset);
        }
        if (EncryptType.SM2_AND_SM4 == algorithmType) {
            return sm4Cryptor.decrypt(content, encryptKey, charset);
        }
        throw new BocomApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aAlgorithmType=" + (Object)((Object)algorithmType));
    }

    public static ByteArrayOutputStream encryptFile(InputStream in, String cryptKey, EncryptType algorithmType) throws Exception {
        if (EncryptType.RSA_AND_AES == algorithmType) {
            return aesCryptor.encryptFile(in, cryptKey);
        }
        if (EncryptType.SM2_AND_SM4 == algorithmType) {
            return sm4Cryptor.encryptFile(in, cryptKey);
        }
        throw new BocomApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aAlgorithmType=" + (Object)((Object)algorithmType));
    }

    public static ByteArrayOutputStream decryptFile(InputStream in, String cryptKey, EncryptType algorithmType) throws Exception {
        if (EncryptType.RSA_AND_AES == algorithmType) {
            return aesCryptor.decryptFile(in, cryptKey);
        }
        if (EncryptType.SM2_AND_SM4 == algorithmType) {
            return sm4Cryptor.decryptFile(in, cryptKey);
        }
        throw new BocomApiException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u7c7b\u578b\uff1aAlgorithmType=" + (Object)((Object)algorithmType));
    }

    public static void takeEncryptFile(FileItem f, EncryptType algorithmType, String encryptKey) throws Exception {
        byte[] encryptContent = null;
        File file = f.getFile();
        try {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream value = BocomEncrypt.encryptFile(in, encryptKey, algorithmType);
            encryptContent = value.toByteArray();
            f.setContent(encryptContent);
        }
        catch (Exception e) {
            throw new Exception("\u63d0\u53d6\u4e0a\u4f20\u52a0\u5bc6\u6587\u4ef6\u5931\u8d25", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptFile(String decryptKey, EncryptType algorithmType, String filePath, String fileName) throws Exception {
        FileOutputStream fos = null;
        InputStream newIn = null;
        try {
            File file = new File(filePath + fileName + ".TMP");
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream output = BocomEncrypt.decryptFile(in, decryptKey, algorithmType);
            byte[] buffer = output.toByteArray();
            newIn = new ByteArrayInputStream(buffer);
            if (!filePath.endsWith("/") && !filePath.endsWith("\\")) {
                filePath = filePath + "/";
            }
            int read = 0;
            File downloadPath = new File(filePath);
            if (!downloadPath.exists()) {
                downloadPath.mkdirs();
            }
            fos = new FileOutputStream(filePath + fileName);
            while ((read = newIn.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
                fos.flush();
            }
            file.delete();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (newIn != null) {
                newIn.close();
            }
        }
    }
}

