/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FileItem {
    private String fileName;
    private String mimeType;
    private byte[] content;
    private File file;

    public FileItem(File file) {
        this.file = file;
    }

    public FileItem(String filePath) {
        this(new File(filePath));
    }

    public String getFileName() {
        if (this.fileName == null && this.file != null && this.file.exists()) {
            this.fileName = this.file.getName();
        }
        return this.fileName;
    }

    public String getMimeType() throws IOException {
        if (this.mimeType == null) {
            this.mimeType = FileItem.getMimeType(this.getContent());
        }
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContent() throws IOException {
        if (this.content == null && this.file != null && this.file.exists()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)this.file.length());
            BufferedInputStream in = null;
            try {
                int len;
                in = new BufferedInputStream(new FileInputStream(this.file));
                int bufSize = 1024;
                byte[] buffer = new byte[bufSize];
                while (-1 != (len = in.read(buffer, 0, bufSize))) {
                    baos.write(buffer, 0, len);
                }
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
            finally {
                if (in != null) {
                    in.close();
                }
                baos.close();
            }
        }
        return this.content;
    }

    public static String getMimeType(byte[] bytes) {
        String suffix = FileItem.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    public static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public void setContent(byte[] encryptContent) {
        this.content = encryptContent;
    }
}

