/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.utils;

import com.bocom.api.utils.Base64;
import com.bocom.api.utils.enums.EncryptType;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static final Logger logger = LoggerFactory.getLogger(SecurityUtil.class);

    public static String parseP12CertFile(String certFilePath, String certPwd) throws Exception {
        Security.removeProvider("SunEC");
        Security.addProvider((Provider)new BouncyCastleProvider());
        FileInputStream fis = new FileInputStream(certFilePath);
        KeyStore ks2 = KeyStore.getInstance("PKCS12", "BC");
        ks2.load(fis, certPwd.toCharArray());
        Enumeration<String> enum1 = ks2.aliases();
        String keyAlias = null;
        if (enum1.hasMoreElements()) {
            keyAlias = enum1.nextElement();
        }
        PrivateKey privateKey = (PrivateKey)ks2.getKey(keyAlias, null);
        logger.debug("[FOBP]>>>> PrivateKey Algorithm: {}", (Object)privateKey.getAlgorithm());
        String keyAlgorithm = privateKey.getAlgorithm();
        String priKeyString = null;
        if ("EC".equals(keyAlgorithm)) {
            BCECPrivateKey privateKeyEC = (BCECPrivateKey)privateKey;
            priKeyString = privateKeyEC.getD().toString(16);
        } else if ("RSA".equals(keyAlgorithm)) {
            priKeyString = Base64.encode(privateKey.getEncoded());
        }
        logger.debug("[FOBP]>>>> PrivateKey String: {}", (Object)priKeyString);
        return priKeyString;
    }

    public static EncryptType getEncryptTypeByPrivateKey(String privateKey) {
        int keyLen = privateKey.length();
        if (keyLen > 64) {
            return EncryptType.RSA_AND_AES;
        }
        return EncryptType.SM2_AND_SM4;
    }
}

