/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.pkcs;

import com.icbc.bcpkix.org.bouncycastle.cms.CMSEncryptedData;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.operator.InputDecryptorProvider;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS12SafeBag;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCSException;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1OctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.cms.ContentInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.SafeBag;

public class PKCS12SafeBagFactory {
    private ASN1Sequence safeBagSeq;

    public PKCS12SafeBagFactory(com.icbc.bcprov.org.bouncycastle.asn1.pkcs.ContentInfo contentInfo) {
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
        }
        this.safeBagSeq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
    }

    public PKCS12SafeBagFactory(com.icbc.bcprov.org.bouncycastle.asn1.pkcs.ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            CMSEncryptedData cMSEncryptedData = new CMSEncryptedData(ContentInfo.getInstance(contentInfo));
            try {
                this.safeBagSeq = ASN1Sequence.getInstance(cMSEncryptedData.getContent(inputDecryptorProvider));
            }
            catch (CMSException cMSException) {
                throw new PKCSException("unable to extract data: " + cMSException.getMessage(), cMSException);
            }
            return;
        }
        throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
    }

    public PKCS12SafeBag[] getSafeBags() {
        PKCS12SafeBag[] pKCS12SafeBagArray = new PKCS12SafeBag[this.safeBagSeq.size()];
        for (int i = 0; i != this.safeBagSeq.size(); ++i) {
            pKCS12SafeBagArray[i] = new PKCS12SafeBag(SafeBag.getInstance(this.safeBagSeq.getObjectAt(i)));
        }
        return pKCS12SafeBagArray;
    }
}

