/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.crypto.modes.gcm;

import com.icbc.bcprov.org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.icbc.bcprov.org.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;
import com.icbc.bcprov.org.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    @Override
    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int i = 0; i < 16; ++i) {
            long[][] lArray = this.T[i];
            if (i == 0) {
                GCMUtil.asLongs(this.H, lArray[1]);
                GCMUtil.multiplyP7(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP8(this.T[i - 1][1], lArray[1]);
            }
            for (int j = 2; j < 256; j += 2) {
                GCMUtil.divideP(lArray[j >> 1], lArray[j]);
                GCMUtil.xor(lArray[j], lArray[1], lArray[j + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] byArray) {
        long[] lArray = this.T[15][byArray[15] & 0xFF];
        long l = lArray[0];
        long l2 = lArray[1];
        for (int i = 14; i >= 0; --i) {
            lArray = this.T[i][byArray[i] & 0xFF];
            l ^= lArray[0];
            l2 ^= lArray[1];
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }
}

