/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric;

import com.icbc.bcprov.org.bouncycastle.crypto.CipherKeyGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.XTEAEngine;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class XTEA {
    private XTEA() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = XTEA.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.XTEA", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.XTEA", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.XTEA", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "XTEA IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("XTEA", 128, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new XTEAEngine());
        }
    }
}

