/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.crypto.qtesla;

import com.icbc.bcprov.org.bouncycastle.pqc.crypto.qtesla.CommonFunction;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.qtesla.HashUtils;
import com.icbc.bcprov.org.bouncycastle.util.Arrays;

class Sample {
    static final double[][] EXPONENTIAL_DISTRIBUTION_I = new double[][]{{1.0, 0.9990496327075997, 0.99810016861319, 0.9971516068584009, 0.9962039465856783, 0.9952571869382832, 0.9943113270602909, 0.9933663660965897, 0.992422303192881, 0.9914791374956781, 0.9905368681523049, 0.9895954943108964, 0.9886550151203967, 0.9877154297305588, 0.9867767372919439, 0.9858389369559202, 0.9849020278746626, 0.983966009201152, 0.9830308800891736, 0.9820966396933174, 0.9811632871689767, 0.9802308216723474, 0.9792992423604274, 0.9783685483910157, 0.9774387389227118, 0.9765098131149148, 0.9755817701278225, 0.9746546091224311, 0.973728329260534, 0.9728029297047213, 0.9718784096183788, 0.9709547681656876}, {1.0, 0.9700320045116229, 0.940962089776837, 0.9127633421156709, 0.8854096543971924, 0.8588757018688518, 0.8331369187101693, 0.8081694752890625, 0.7839502560997557, 0.7604568383618461, 0.7376674712607126, 0.715561055810049, 0.6941171253178751, 0.6733158264379437, 0.6531379007889985, 0.6335646671248656, 0.6145780040388725, 0.5961603331865797, 0.5782946030112949, 0.5609642729572996, 0.5441532981561744, 0.5278461145720446, 0.5120276245919921, 0.49668318304829484, 0.48179858365955075, 0.46736004587813484, 0.45335420213181116, 0.4397680854476882, 0.42658911744705963, 0.4138050967000153, 0.40140418742904177, 0.3893749085511526}, {1.0, 0.37770612304840434, 0.14266191538825637, 0.05388427896795781, 0.02035242210224602, 0.007687234446884, 0.0029035155198967005, 0.0010966755902310549, 4.142210854279923E-4, 1.5645384026190888E-4, 5.9093573441359953E-5, 2.232000452161222E-5, 8.430402374281007E-6, 3.184214596527742E-6, 1.2026973502086328E-6, 4.5426615334789165E-7, 1.715791076131441E-7, 6.480647953266561E-8, 2.4477804132698898E-8, 9.24541649969991E-9, 3.4920504220694024E-9, 1.318968826409378E-9, 4.9818260184479E-10, 1.881666191129625E-10, 7.107168419228285E-11, 2.6844210294787717E-11, 1.0139222596740334E-11, 3.829646457739566E-12, 1.4464809161988664E-12, 5.463446989209777E-13, 2.0635773807749023E-13, 7.794258121028692E-14}};
    static final double[][] EXPONENTIAL_DISTRIBUTION_III_SIZE = new double[][]{{1.0, 0.9914791374956781, 0.9830308800891736, 0.9746546091224311, 0.9663497112088952, 0.9581155781885929, 0.9499516070835989, 0.94185720005388, 0.9338317643535151, 0.9258747122872905, 0.9179854611676618, 0.9101634332720855, 0.9024080558007124, 0.894718760834442, 0.8870949852933344, 0.8795361708953764, 0.872041764115599, 0.8646112161455436, 0.8572439828530728, 0.8499395247425244, 0.8426973069152046, 0.8355167990302177, 0.82839747526563, 0.8213388142799641, 0.8143402991740217, 0.8074014174530314, 0.8005216609891195, 0.7937005259840998, 0.7869375129325812, 0.7802321265853895, 0.7735838759133007, 0.766992274071083}, {1.0, 0.7604568383618461, 0.5782946030112949, 0.4397680854476882, 0.3344246478719911, 0.254315510391008, 0.19339596897832517, 0.14706928712118283, 0.11183984510430525, 0.08504937501089856, 0.06467637882543892, 0.049183594558286324, 0.037402000817065316, 0.02844260728975267, 0.021629375214332912, 0.016448206291233683, 0.012508150952954992, 0.009511908927436865, 0.007233396189744457, 0.005500685597071693, 0.004183033977971684, 0.0031810167936485224, 0.002419025973673892, 0.0018395648438552343, 0.0013989096651197545, 0.0010638104210907973, 8.089819094390918E-4, 6.15195825143981E-4, 4.678298721623989E-4, 3.557644254758445E-4, 2.7054349019897927E-4, 2.0573664719609488E-4}, {1.0, 1.5645384026190888E-4, 2.4477804132698898E-8, 3.829646457739566E-12, 5.991628951587712E-16, 9.374133589003324E-20, 1.4666191991277205E-23, 2.294582059053771E-27, 3.5899617493504067E-31, 5.616633020792314E-35, 8.787438054448035E-39, 1.3748284296820321E-42, 2.1509718752500368E-46, 3.365278101782278E-50, 5.265106825731444E-54, 8.237461822748735E-58, 1.2887825361799032E-61, 2.016349770478284E-65, 3.15465664902546E-69, 4.93558147447798E-73, 7.721906756076147E-77, 1.2081219661324923E-80, 1.8901532110619624E-84, 2.957217285540224E-88, 4.626680008116659E-92, 7.238618549328511E-96, 1.1325096702335332E-99, 1.7718548704178432E-103, 2.7721349886363846E-107, 4.337111646965655E-111, 6.78557772812429E-115, 1.0616296939607244E-118}};
    static final double[][] EXPONENTIAL_DISTRIBUTION_III_SPEED = new double[][]{{1.0, 0.9951980443443538, 0.9904191474668262, 0.9856631986401876, 0.980930087668915, 0.9762197048866396, 0.9715319411536059, 0.9668666878541423, 0.9622238368941451, 0.9576032806985737, 0.9530049122089577, 0.9484286248809173, 0.9438743126816935, 0.9393418700876924, 0.9348311920820395, 0.9303421741521466, 0.9258747122872905, 0.9214287029762026, 0.9170040432046712, 0.9126006304531541, 0.9082183626944031, 0.903857138391101, 0.8995168564935077, 0.8951974164371195, 0.8908987181403393, 0.8866206620021573, 0.8823631488998432, 0.8781260801866497, 0.8739093576895269, 0.8697128837068475, 0.8655365610061431, 0.8613802928218509}, {1.0, 0.8572439828530728, 0.7348672461377994, 0.6299605249474366, 0.540029869446153, 0.46293735614364523, 0.3968502629920499, 0.3401975000435942, 0.29163225989402913, 0.25, 0.2143109957132682, 0.18371681153444985, 0.15749013123685915, 0.13500746736153826, 0.11573433903591131, 0.09921256574801247, 0.08504937501089856, 0.07290806497350728, 0.0625, 0.05357774892831705, 0.04592920288361246, 0.03937253280921479, 0.033751866840384566, 0.028933584758977827, 0.02480314143700312, 0.02126234375272464, 0.01822701624337682, 0.015625, 0.013394437232079262, 0.011482300720903116, 0.009843133202303697, 0.008437966710096141}, {1.0, 0.007233396189744457, 5.232202043780962E-5, 3.784659032745837E-7, 2.7375938226945676E-9, 1.9802100726146846E-11, 1.4323643994144654E-13, 1.03608591890502E-15, 7.494419938055456E-18, 5.421010862427522E-20, 3.921231931684655E-22, 2.8363824113752076E-24, 2.0516677727099623E-26, 1.4840525849741735E-28, 1.0734740313532598E-30, 7.764862968180291E-33, 5.616633020792314E-35, 4.062733189179202E-37, 2.938735877055719E-39, 2.125704089576017E-41, 1.537605986206337E-43, 1.1122113281953186E-45, 8.045065183558638E-48, 5.819314384499884E-50, 4.209340649576657E-52, 3.0447828615984243E-54, 2.2024120749685265E-56, 1.5930919111324523E-58, 1.1523464959898195E-60, 8.335378753358135E-63, 6.029309691461764E-65, 4.3612385749008845E-67}};
    static final double[][] EXPONENTIAL_DISTRIBUTION_P = new double[][]{{1.0, 0.9930924954370359, 0.9862327044933592, 0.9794202975869268, 0.9726549474122855, 0.9659363289248456, 0.9592641193252643, 0.9526379980439373, 0.9460576467255959, 0.9395227492140118, 0.9330329915368074, 0.9265880618903709, 0.9201876506248751, 0.9138314502294005, 0.9075191553171609, 0.9012504626108302, 0.8950250709279725, 0.8888426811665702, 0.8827029962906549, 0.8766057213160351, 0.8705505632961241, 0.8645372313078652, 0.8585654364377537, 0.8526348917679567, 0.8467453123625271, 0.8408964152537145, 0.8350879194283694, 0.8293195458144417, 0.8235910172675731, 0.8179020585577811, 0.8122523963562355, 0.8066417592221263}, {1.0, 0.8010698775896221, 0.6417129487814521, 0.5140569133280333, 0.41179550863378656, 0.32987697769322355, 0.26425451014034507, 0.2116863280906318, 0.16957554093095897, 0.13584185781575725, 0.10881882041201552, 0.08717147914690034, 0.06983044612951375, 0.05593906693299828, 0.0448111015004946, 0.03589682359365735, 0.028755864082027346, 0.023035456520173456, 0.01845301033483641, 0.014782150730087436, 0.011841535675862484, 0.009485897534336304, 0.007598866776658481, 0.0060872232785976555, 0.004876291206646921, 0.00390625, 0.0031291792093344614, 0.0025066912061775474, 0.00200803481768763, 0.0016085762056007287, 0.0012885819441141545, 0.001032244180235723}, {1.0, 8.268997191040304E-4, 6.837631454543244E-7, 5.654035529098692E-10, 4.675320390815916E-13, 3.866021117887027E-16, 3.196811776431032E-19, 2.643442759959277E-22, 2.185862075677909E-25, 1.807488736378216E-28, 1.4946119283948456E-31, 1.2358941837592312E-34, 1.0219605533928131E-37, 8.450588945359167E-41, 6.987789625181121E-44, 5.778201278220326E-47, 4.777993013886938E-50, 3.9509210810641284E-53, 3.26701553213412E-56, 2.701494225830208E-59, 2.2338648165001596E-62, 1.8471821892803583E-65, 1.5274344334498962E-68, 1.263035103969543E-71, 1.044403372690945E-74, 8.636168555094445E-78, 7.1412453523426565E-81, 5.905093775905105E-84, 4.882920384578891E-87, 4.037685494415629E-90, 3.3387610011627014E-93, 2.760820534016929E-96}};
    static final long[][] CUMULATIVE_DISTRIBUTION_TABLE_I = new long[][]{{0x200000000000000L, 0L}, {0x300000000000000L, 0L}, {0x320000000000000L, 0L}, {225461456345235456L, 0L}, {225463655368491008L, 0L}, {225463659663458304L, 0L}, {225463659665555456L, 0L}, {225463659665555712L, 0L}, {225463659665555712L, 0x200000000000000L}, {225463659665555712L, 0x200010000000000L}, {225463659665555712L, 0x200010000200000L}, {225463659665555712L, 0x200010000200001L}};
    static final long[][] CUMULATIVE_DISTRIBUTION_TABLE_III = new long[][]{{0x20000000000L, 0L, 0L}, {0x30000000000L, 0L, 0L}, {0x32000000000L, 0L, 0L}, {3440268804096L, 0L, 0L}, {3440302358528L, 0L, 0L}, {3440302424064L, 0L, 0L}, {3440302424096L, 0L, 0L}, {3440302424096L, 0x100000000000000L, 0L}, {3440302424096L, 0x100020000000000L, 0L}, {3440302424096L, 0x100020001000000L, 0L}, {3440302424096L, 0x100020001000020L, 0L}, {3440302424096L, 0x100020001000020L, 0x1000000000000L}, {3440302424096L, 0x100020001000020L, 0x1000002000000L}, {3440302424096L, 0x100020001000020L, 0x1000002000001L}};

    Sample() {
    }

    private static long modulus7(long l) {
        long l2 = l;
        for (int i = 0; i < 2; ++i) {
            l2 = (l2 & 7L) + (l2 >> 3);
        }
        return l2 - 7L >> 3 & l2;
    }

    public static void sampleY(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = (n6 + 1 + 7) / 8;
        int n10 = n3;
        byte[] byArray2 = new byte[n3 * n9];
        int[] nArray2 = new int[4];
        short s = (short)(n2 << 8);
        if (n4 == 4205569) {
            short s2 = s;
            s = (short)(s + 1);
            HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, n3 * n9, s2, byArray, n, 32);
        }
        if (n4 == 4206593 || n4 == 8404993) {
            short s3 = s;
            s = (short)(s + 1);
            HashUtils.customizableSecureHashAlgorithmKECCAK256Simple(byArray2, 0, n3 * n9, s3, byArray, n, 32);
        }
        while (n7 < n3) {
            if (n8 > n10 * n9 * 4) {
                if (n4 == 4205569) {
                    n10 = 168 / ((n6 + 1 + 7) / 8);
                    short s4 = s;
                    s = (short)(s + 1);
                    HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168, s4, byArray, n, 32);
                }
                if (n4 == 4206593 || n4 == 8404993) {
                    n10 = 136 / ((n6 + 1 + 7) / 8);
                    short s5 = s;
                    s = (short)(s + 1);
                    HashUtils.customizableSecureHashAlgorithmKECCAK256Simple(byArray2, 0, 136, s5, byArray, n, 32);
                }
                n8 = 0;
            }
            nArray2[0] = (CommonFunction.load32(byArray2, n8) & (1 << n6 + 1) - 1) - n5;
            nArray2[1] = (CommonFunction.load32(byArray2, n8 + n9) & (1 << n6 + 1) - 1) - n5;
            nArray2[2] = (CommonFunction.load32(byArray2, n8 + n9 * 2) & (1 << n6 + 1) - 1) - n5;
            nArray2[3] = (CommonFunction.load32(byArray2, n8 + n9 * 3) & (1 << n6 + 1) - 1) - n5;
            if (n7 < n3 && nArray2[0] != 1 << n6) {
                nArray[n7++] = nArray2[0];
            }
            if (n7 < n3 && nArray2[1] != 1 << n6) {
                nArray[n7++] = nArray2[1];
            }
            if (n7 < n3 && nArray2[2] != 1 << n6) {
                nArray[n7++] = nArray2[2];
            }
            if (n7 < n3 && nArray2[3] != 1 << n6) {
                nArray[n7++] = nArray2[3];
            }
            n8 += n9 * 4;
        }
    }

    public static void sampleY(long[] lArray, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = (n6 + 1 + 7) / 8;
        int n10 = n3;
        byte[] byArray2 = new byte[n3 * n9];
        short s = (short)(n2 << 8);
        if (n4 == 485978113) {
            short s2 = s;
            s = (short)(s + 1);
            HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, n3 * n9, s2, byArray, n, 32);
        }
        if (n4 == 1129725953) {
            short s3 = s;
            s = (short)(s + 1);
            HashUtils.customizableSecureHashAlgorithmKECCAK256Simple(byArray2, 0, n3 * n9, s3, byArray, n, 32);
        }
        while (n7 < n3) {
            if (n8 > n10 * n9) {
                if (n4 == 485978113) {
                    n10 = 168 / ((n6 + 1 + 7) / 8);
                    short s4 = s;
                    s = (short)(s + 1);
                    HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168, s4, byArray, n, 32);
                }
                if (n4 == 1129725953) {
                    n10 = 136 / ((n6 + 1 + 7) / 8);
                    short s5 = s;
                    s = (short)(s + 1);
                    HashUtils.customizableSecureHashAlgorithmKECCAK256Simple(byArray2, 0, 136, s5, byArray, n, 32);
                }
                n8 = 0;
            }
            lArray[n7] = (CommonFunction.load32(byArray2, n8) & (1 << n6 + 1) - 1) - n5;
            if (lArray[n7] != (long)(1 << n6)) {
                ++n7;
            }
            n8 += n9;
        }
    }

    private static int bernoulli(long l, long l2, double[][] dArray) {
        double d = 4.611686018427388E18;
        long l3 = 0L;
        long l4 = l2;
        while (l3 < 3L) {
            d *= dArray[(int)l3][(int)(l4 & 0x1FL)];
            ++l3;
            l4 >>= 5;
        }
        return (int)((l & 0x3FFFFFFFFFFFFFFFL) - Sample.round(d) >>> 63);
    }

    public static void polynomialGaussSamplerI(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[1024];
        short s = (short)(n3 << 8);
        int n4 = 0;
        short s2 = s;
        s = (short)(s + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 1024, s2, byArray, n2, 32);
        for (int i = 0; i < 512; ++i) {
            long l;
            long l2;
            long l3;
            long l4;
            if (n4 + 46 > 512) {
                short s3 = s;
                s = (short)(s + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 1024, s3, byArray, n2, 32);
                n4 = 0;
            }
            do {
                l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                l = 64L;
                while (true) {
                    long l5;
                    long l6;
                    long l7 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    long l8 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    if (l <= 58L) {
                        l2 = l2 << 6 ^ l7 >>> 58 & 0x3FL;
                        l += 6L;
                    }
                    if ((l7 &= 0x3FFFFFFFFFFFFFFL) > 225463659665555712L) continue;
                    long l9 = 0L;
                    for (int j = 0; j < 12; ++j) {
                        long l10 = l8 - CUMULATIVE_DISTRIBUTION_TABLE_I[j][1];
                        long l11 = (l10 & CUMULATIVE_DISTRIBUTION_TABLE_I[j][1] & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_I[j][1] >> 1) + (l10 >>> 1) >>> 63;
                        l10 = l7 - (CUMULATIVE_DISTRIBUTION_TABLE_I[j][0] + l11);
                        l9 += (l10 >>> 63 ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                    }
                    while (true) {
                        if (l < 6L) {
                            l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                            l = 64L;
                        }
                        l6 = l2 & 0x3FL;
                        l2 >>= 6;
                        l -= 6L;
                        if (l6 == 63L) continue;
                        if (l < 2L) {
                            l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                            l = 64L;
                        }
                        l6 = (Sample.modulus7(l6) << 2) + (l2 & 3L);
                        l2 >>= 2;
                        l -= 2L;
                        if (!((double)l6 >= 27.0)) break;
                    }
                    l4 = (long)(27.0 * (double)l9 + (double)l6);
                    if (Sample.bernoulli(l5 = CommonFunction.load64(byArray2, n4++ * 64 / 32), l6 * ((l4 << 1) - l6), EXPONENTIAL_DISTRIBUTION_I) != 0) break;
                }
                l2 <<= (int)(64L - l);
                if (l == 0L) {
                    l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    l = 64L;
                }
                l3 = l2 >> 63;
                l2 <<= 1;
                --l;
            } while ((l4 | l3 & 1L) == 0L);
            if (l == 0L) {
                l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                l = 64L;
            }
            l3 = l2 >> 63;
            l2 <<= 1;
            --l;
            l4 = (l4 << 1 & l3) - l4;
            nArray[n + i] = (int)(l4 << 48 >> 48);
        }
    }

    public static void polynomialGaussSamplerIP(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[2048];
        short s = (short)(n3 << 8);
        int n4 = 0;
        short s2 = s;
        s = (short)(s + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 2048, s2, byArray, n2, 32);
        for (int i = 0; i < 1024; ++i) {
            long l;
            long l2;
            long l3;
            long l4;
            if (n4 + 46 > 1024) {
                short s3 = s;
                s = (short)(s + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 2048, s3, byArray, n2, 32);
                n4 = 0;
            }
            do {
                l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                l = 64L;
                while (true) {
                    long l5;
                    long l6;
                    long l7 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    long l8 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    if (l <= 58L) {
                        l2 = l2 << 6 ^ l7 >>> 58 & 0x3FL;
                        l += 6L;
                    }
                    if ((l7 &= 0x3FFFFFFFFFFFFFFL) > 225463659665555712L) continue;
                    long l9 = 0L;
                    for (int j = 0; j < 12; ++j) {
                        long l10 = l8 - CUMULATIVE_DISTRIBUTION_TABLE_I[j][1];
                        long l11 = (l10 & CUMULATIVE_DISTRIBUTION_TABLE_I[j][1] & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_I[j][1] >> 1) + (l10 >>> 1) >>> 63;
                        l10 = l7 - (CUMULATIVE_DISTRIBUTION_TABLE_I[j][0] + l11);
                        l9 += (l10 >>> 63 ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                    }
                    while (true) {
                        if (l < 6L) {
                            l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                            l = 64L;
                        }
                        l6 = l2 & 0x3FL;
                        l2 >>= 6;
                        l -= 6L;
                        if (l6 == 63L) continue;
                        if (l < 2L) {
                            l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                            l = 64L;
                        }
                        l6 = (Sample.modulus7(l6) << 2) + (l2 & 3L);
                        l2 >>= 2;
                        l -= 2L;
                        if (!((double)l6 >= 10.0)) break;
                    }
                    l4 = (long)(10.0 * (double)l9 + (double)l6);
                    if (Sample.bernoulli(l5 = CommonFunction.load64(byArray2, n4++ * 64 / 32), l6 * ((l4 << 1) - l6), EXPONENTIAL_DISTRIBUTION_P) != 0) break;
                }
                l2 <<= (int)(64L - l);
                if (l == 0L) {
                    l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    l = 64L;
                }
                l3 = l2 >> 63;
                l2 <<= 1;
                --l;
            } while ((l4 | l3 & 1L) == 0L);
            if (l == 0L) {
                l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                l = 64L;
            }
            l3 = l2 >> 63;
            l2 <<= 1;
            --l;
            l4 = (l4 << 1 & l3) - l4;
            lArray[n + i] = l4 << 48 >> 48;
        }
    }

    public static void polynomialGaussSamplerIII(int[] nArray, int n, byte[] byArray, int n2, int n3, int n4, double d, double[][] dArray) {
        byte[] byArray2 = new byte[n4 * 64 / 32];
        short s = (short)(n3 << 8);
        int n5 = 0;
        short s2 = s;
        s = (short)(s + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK256Simple(byArray2, 0, n4 * 64 / 32, s2, byArray, n2, 32);
        for (int i = 0; i < n4; ++i) {
            long l;
            long l2;
            long l3;
            long l4;
            if (n5 + 46 > n4) {
                short s3 = s;
                s = (short)(s + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK256Simple(byArray2, 0, n4 * 64 / 32, s3, byArray, n2, 32);
                n5 = 0;
            }
            do {
                l2 = CommonFunction.load64(byArray2, n5++ * 64 / 32);
                l = 64L;
                while (true) {
                    long l5;
                    long l6 = CommonFunction.load64(byArray2, n5++ * 64 / 32);
                    long l7 = CommonFunction.load64(byArray2, n5++ * 64 / 32);
                    long l8 = CommonFunction.load64(byArray2, n5++ * 64 / 32);
                    if (l <= 58L) {
                        l2 = l2 << 6 ^ l6 >>> 58 & 0x3FL;
                        l += 6L;
                    }
                    if ((l6 &= 0x3FFFFFFFFFFL) > 3440302424096L) continue;
                    long l9 = 0L;
                    for (int j = 0; j < 14; ++j) {
                        long l10 = l8 - CUMULATIVE_DISTRIBUTION_TABLE_III[j][2];
                        long l11 = (l10 & CUMULATIVE_DISTRIBUTION_TABLE_III[j][2] & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_III[j][2] >> 1) + (l10 >>> 1) >> 63;
                        l10 = l7 - (CUMULATIVE_DISTRIBUTION_TABLE_III[j][1] + l11);
                        l11 = (l10 & l11 & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_III[j][1] >> 1) + (l10 >>> 1) >> 63;
                        l10 = l6 - (CUMULATIVE_DISTRIBUTION_TABLE_III[j][0] + l11);
                        l9 += (l10 >>> 63 ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                    }
                    while (true) {
                        if (l < 6L) {
                            l2 = CommonFunction.load64(byArray2, n5++ * 64 / 32);
                            l = 64L;
                        }
                        l5 = l2 & 0x3FL;
                        l2 >>= 6;
                        l -= 6L;
                        if (l5 == 63L) continue;
                        if (l < 2L) {
                            l2 = CommonFunction.load64(byArray2, n5++ * 64 / 32);
                            l = 64L;
                        }
                        l5 = (Sample.modulus7(l5) << 2) + (l2 & 3L);
                        l2 >>= 2;
                        l -= 2L;
                        if (!((double)l5 >= d)) break;
                    }
                    l4 = (long)(d * (double)l9 + (double)l5);
                    if (Sample.bernoulli(CommonFunction.load64(byArray2, n5++ * 64 / 32), l5 * ((l4 << 1) - l5), dArray) != 0) break;
                }
                l2 <<= (int)(64L - l);
                if (l == 0L) {
                    l2 = CommonFunction.load64(byArray2, n5++ * 64 / 32);
                    l = 64L;
                }
                l3 = l2 >> 63;
                l2 <<= 1;
                --l;
            } while ((l4 | l3 & 1L) == 0L);
            if (l == 0L) {
                l2 = CommonFunction.load64(byArray2, n5++ * 64 / 32);
                l = 64L;
            }
            l3 = l2 >> 63;
            l2 <<= 1;
            --l;
            l4 = (l4 << 1 & l3) - l4;
            nArray[n + i] = (int)(l4 << 48 >> 48);
        }
    }

    public static void polynomialGaussSamplerIIIP(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[4096];
        short s = (short)(n3 << 8);
        int n4 = 0;
        short s2 = s;
        s = (short)(s + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK256Simple(byArray2, 0, 4096, s2, byArray, n2, 32);
        for (int i = 0; i < 2048; ++i) {
            long l;
            long l2;
            long l3;
            long l4;
            if (n4 + 46 > 2048) {
                short s3 = s;
                s = (short)(s + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK256Simple(byArray2, 0, 4096, s3, byArray, n2, 32);
                n4 = 0;
            }
            do {
                l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                l = 64L;
                while (true) {
                    long l5;
                    long l6 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    long l7 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    long l8 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    if (l <= 58L) {
                        l2 = l2 << 6 ^ l6 >>> 58 & 0x3FL;
                        l += 6L;
                    }
                    if ((l6 &= 0x3FFFFFFFFFFL) > 3440302424096L) continue;
                    long l9 = 0L;
                    for (int j = 0; j < 14; ++j) {
                        long l10 = l8 - CUMULATIVE_DISTRIBUTION_TABLE_III[j][2];
                        long l11 = (l10 & CUMULATIVE_DISTRIBUTION_TABLE_III[j][2] & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_III[j][2] >> 1) + (l10 >>> 1) >> 63;
                        l10 = l7 - (CUMULATIVE_DISTRIBUTION_TABLE_III[j][1] + l11);
                        l11 = (l10 & l11 & 1L) + (CUMULATIVE_DISTRIBUTION_TABLE_III[j][1] >> 1) + (l10 >>> 1) >> 63;
                        l10 = l6 - (CUMULATIVE_DISTRIBUTION_TABLE_III[j][0] + l11);
                        l9 += (l10 >>> 63 ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                    }
                    while (true) {
                        if (l < 6L) {
                            l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                            l = 64L;
                        }
                        l5 = l2 & 0x3FL;
                        l2 >>= 6;
                        l -= 6L;
                        if (l5 == 63L) continue;
                        if (l < 2L) {
                            l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                            l = 64L;
                        }
                        l5 = (Sample.modulus7(l5) << 2) + (l2 & 3L);
                        l2 >>= 2;
                        l -= 2L;
                        if (!((double)l5 >= 10.0)) break;
                    }
                    l4 = (long)(10.0 * (double)l9 + (double)l5);
                    if (Sample.bernoulli(CommonFunction.load64(byArray2, n4++ * 64 / 32), l5 * ((l4 << 1) - l5), EXPONENTIAL_DISTRIBUTION_P) != 0) break;
                }
                l2 <<= (int)(64L - l);
                if (l == 0L) {
                    l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                    l = 64L;
                }
                l3 = l2 >> 63;
                l2 <<= 1;
                --l;
            } while ((l4 | l3 & 1L) == 0L);
            if (l == 0L) {
                l2 = CommonFunction.load64(byArray2, n4++ * 64 / 32);
                l = 64L;
            }
            l3 = l2 >> 63;
            l2 <<= 1;
            --l;
            l4 = (l4 << 1 & l3) - l4;
            lArray[n + i] = l4 << 48 >> 48;
        }
    }

    public static void encodeC(int[] nArray, short[] sArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        short s = 0;
        short[] sArray2 = new short[n2];
        byte[] byArray2 = new byte[168];
        short s2 = s;
        s = (short)(s + 1);
        HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168, s2, byArray, n, 32);
        Arrays.fill(sArray2, (short)0);
        int n5 = 0;
        while (n5 < n3) {
            if (n4 > 165) {
                short s3 = s;
                s = (short)(s + 1);
                HashUtils.customizableSecureHashAlgorithmKECCAK128Simple(byArray2, 0, 168, s3, byArray, n, 32);
                n4 = 0;
            }
            int n6 = byArray2[n4] << 8 | byArray2[n4 + 1] & 0xFF;
            if (sArray2[n6 &= n2 - 1] == 0) {
                sArray2[n6] = (byArray2[n4 + 2] & 1) == 1 ? -1 : 1;
                nArray[n5] = n6;
                sArray[n5] = sArray2[n6];
                ++n5;
            }
            n4 += 3;
        }
    }

    private static long round(double d) {
        if (d < 0.0) {
            return (long)(d - 0.5);
        }
        return (long)(d + 0.5);
    }
}

