/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.cert;

import com.icbc.bcpkix.org.bouncycastle.operator.DigestCalculator;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SM3Digest;
import java.io.IOException;
import java.io.OutputStream;

public class GmDigestCalculatorProvider
extends BcDigestCalculatorProvider {
    @Override
    public DigestCalculator get(final AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        if (algorithmIdentifier.getAlgorithm().equals(GMObjectIdentifiers.sm3)) {
            return new DigestCalculator(){
                Digest dig = new SM3Digest();
                final DigestOutputStream stream = new DigestOutputStream(this.dig);

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return algorithmIdentifier;
                }

                @Override
                public OutputStream getOutputStream() {
                    return this.stream;
                }

                @Override
                public byte[] getDigest() {
                    return this.stream.getDigest();
                }
            };
        }
        return super.get(algorithmIdentifier);
    }

    private static class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest digest) {
            this.dig = digest;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray, 0, byArray.length);
        }

        @Override
        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }

        byte[] getDigest() {
            byte[] byArray = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(byArray, 0);
            return byArray;
        }
    }
}

