/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.cert;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.X509v3CertificateBuilder;
import com.icbc.bcpkix.org.bouncycastle.cert.bc.BcX509v3CertificateBuilder;
import com.icbc.bcpkix.org.bouncycastle.openssl.PEMParser;
import com.icbc.bcpkix.org.bouncycastle.operator.ContentSigner;
import com.icbc.bcpkix.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcContentSignerBuilder;
import com.icbc.bcpkix.org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.icbc.bcpkix.org.bouncycastle.pkcs.bc.BcPKCS10CertificationRequestBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMNamedCurves;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.X500Name;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.BasicConstraints;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.KeyUsage;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.X509Extensions;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECCurve;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.util.encoders.Hex;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemObject;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemWriter;
import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.cert.IcbcContentSignerBuilder;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import com.icbc.hsm.software.parms.icbc.TempKeyBuilder;
import com.icbc.hsm.utils.encoders.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.cert.CertificateEncodingException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.HashMap;

public class IcbcCertificateHelper {
    public static String generateCertificate(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, X500Name x500Name2, IcbcAsymmetricKeyParameter icbcAsymmetricKeyParameter, IcbcAsymmetricKeyParameter icbcAsymmetricKeyParameter2, String string) throws Exception {
        Object object;
        Object object2;
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        AsymmetricKeyParameter asymmetricKeyParameter2 = null;
        asymmetricKeyParameter = (AsymmetricKeyParameter)icbcAsymmetricKeyParameter.getBCkey();
        asymmetricKeyParameter2 = (AsymmetricKeyParameter)icbcAsymmetricKeyParameter2.getBCkey();
        String string2 = icbcAsymmetricKeyParameter2.getKeyType();
        BcContentSignerBuilder bcContentSignerBuilder = null;
        if (string2 == null) {
            throw new Exception("signatureAlgorithm Name not found in sign private key");
        }
        if (string2.indexOf("RSA") >= 0) {
            object2 = new DefaultSignatureAlgorithmIdentifierFinder().find(string + "WITHRSA");
            object = new DefaultDigestAlgorithmIdentifierFinder().find(string);
            bcContentSignerBuilder = new BcRSAContentSignerBuilder((AlgorithmIdentifier)object2, (AlgorithmIdentifier)object);
        } else if (string2.indexOf("SM2") >= 0) {
            object2 = new DefaultSignatureAlgorithmIdentifierFinder().find("SM3WITHSM2");
            object = new DefaultDigestAlgorithmIdentifierFinder().find(string);
            bcContentSignerBuilder = new IcbcContentSignerBuilder((AlgorithmIdentifier)object2, (AlgorithmIdentifier)object);
        }
        object2 = bcContentSignerBuilder.build(asymmetricKeyParameter2);
        object = new BcX509v3CertificateBuilder(x500Name, bigInteger, date, date2, x500Name2, asymmetricKeyParameter);
        ((X509v3CertificateBuilder)object).addExtension(X509Extensions.BasicConstraints, true, new BasicConstraints(true));
        ((X509v3CertificateBuilder)object).addExtension(X509Extensions.KeyUsage, false, new KeyUsage(192));
        ((X509v3CertificateBuilder)object).addExtension(X509Extensions.AuthorityKeyIdentifier, false, new AuthorityKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter)));
        ((X509v3CertificateBuilder)object).addExtension(X509Extensions.SubjectKeyIdentifier, false, new AuthorityKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter)));
        X509CertificateHolder x509CertificateHolder = ((X509v3CertificateBuilder)object).build((ContentSigner)object2);
        String string3 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PemWriter pemWriter = new PemWriter(new OutputStreamWriter(byteArrayOutputStream));
        try {
            pemWriter.writeObject(new PemObject("CERTIFICATE", x509CertificateHolder.getEncoded()));
            pemWriter.close();
        }
        catch (Exception exception) {
            throw new CertificateEncodingException("can't encode certificate to PEM");
        }
        string3 = byteArrayOutputStream.toString();
        return string3;
    }

    public static String generatePKCS10CertificationRequest(X500Name x500Name, IcbcAsymmetricKeyParameter icbcAsymmetricKeyParameter, IcbcAsymmetricKeyParameter icbcAsymmetricKeyParameter2, String string) throws Exception {
        Object object;
        Object object2;
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        AsymmetricKeyParameter asymmetricKeyParameter2 = null;
        asymmetricKeyParameter = (AsymmetricKeyParameter)icbcAsymmetricKeyParameter.getBCkey();
        asymmetricKeyParameter2 = (AsymmetricKeyParameter)icbcAsymmetricKeyParameter2.getBCkey();
        BcPKCS10CertificationRequestBuilder bcPKCS10CertificationRequestBuilder = new BcPKCS10CertificationRequestBuilder(x500Name, asymmetricKeyParameter);
        String string2 = icbcAsymmetricKeyParameter2.getKeyType();
        BcContentSignerBuilder bcContentSignerBuilder = null;
        if (string2 == null) {
            throw new Exception("signatureAlgorithm Name not found in sign private key");
        }
        if (string2.indexOf("RSA") >= 0) {
            object2 = new DefaultSignatureAlgorithmIdentifierFinder().find(string + "WITHRSA");
            object = new DefaultDigestAlgorithmIdentifierFinder().find(string);
            bcContentSignerBuilder = new BcRSAContentSignerBuilder((AlgorithmIdentifier)object2, (AlgorithmIdentifier)object);
        } else if (string2.indexOf("SM2") >= 0) {
            object2 = new DefaultSignatureAlgorithmIdentifierFinder().find("SM3WITHSM2");
            object = new DefaultDigestAlgorithmIdentifierFinder().find(string);
            bcContentSignerBuilder = new IcbcContentSignerBuilder((AlgorithmIdentifier)object2, (AlgorithmIdentifier)object);
        }
        object2 = bcContentSignerBuilder.build(asymmetricKeyParameter2);
        object = bcPKCS10CertificationRequestBuilder.build((ContentSigner)object2);
        String string3 = Base64.toBase64String(((PKCS10CertificationRequest)object).getEncoded());
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HsmKeyParameter getPubicKeyFromCert(byte[] byArray) throws Exception {
        Object object;
        Object object2;
        ClearKeyParameter clearKeyParameter = null;
        X509CertificateHolder x509CertificateHolder = null;
        BufferedReader bufferedReader = null;
        try {
            object2 = new ByteArrayInputStream(byArray);
            bufferedReader = new PEMParser(new InputStreamReader((InputStream)object2));
            object = ((PEMParser)bufferedReader).readObject();
            if (object instanceof X509CertificateHolder) {
                x509CertificateHolder = (X509CertificateHolder)object;
            }
        }
        catch (Exception exception) {
        }
        finally {
            bufferedReader.close();
        }
        if (x509CertificateHolder == null) {
            object2 = new String(byArray);
            if (((String)object2).matches("[\\p{Alnum}\\p{Space}\\+\\/\\=]+")) {
                byArray = Base64.decode((String)object2);
            }
            x509CertificateHolder = new X509CertificateHolder(byArray);
        }
        object2 = x509CertificateHolder.getSubjectPublicKeyInfo();
        object = ((SubjectPublicKeyInfo)object2).getAlgorithmId().getAlgorithm().toString();
        String string = ((SubjectPublicKeyInfo)object2).getAlgorithmId().getParameters().toString();
        byte[] byArray2 = null;
        if (((String)object).startsWith("1.2.840.10045.2.1") && string.startsWith("1.2.156.10197.1.301")) {
            byArray2 = ((SubjectPublicKeyInfo)object2).getPublicKeyData().getBytes();
            clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"SM2", (byte[])byArray2) : ClearKeyParameter.getInstance("SM2", byArray2);
        } else if (((String)object).startsWith("1.2.840.113549.1.1")) {
            ASN1Primitive aSN1Primitive = ((SubjectPublicKeyInfo)object2).parsePublicKey();
            RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(aSN1Primitive);
            byArray2 = rSAPublicKey.getEncoded();
            clearKeyParameter = IcbcEnvironment.isICBCEnvironment() ? TempKeyBuilder.LoadKey((String)"RSA", (byte[])byArray2) : ClearKeyParameter.getInstance("RSA", byArray2);
        }
        return clearKeyParameter;
    }

    public HashMap<String, String> getPubicKeyFromCert(byte[] byArray, String string) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HsmKeyParameter hsmKeyParameter = IcbcCertificateHelper.getPubicKeyFromCert(byArray);
        try {
            if (hsmKeyParameter.getAlgorithm().equalsIgnoreCase(string) && string.equalsIgnoreCase("RSA")) {
                String string2 = ((ClearKeyParameter)hsmKeyParameter).getPublicKey();
                ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(Hex.decode(string2));
                RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(aSN1Primitive);
                String string3 = rSAPublicKey.getModulus().toString(16);
                String string4 = rSAPublicKey.getPublicExponent().toString(16);
                hashMap.put("pubStringKey", string2);
                hashMap.put("modulus", string3);
                hashMap.put("exponent", string4);
            } else if (hsmKeyParameter.getAlgorithm().equalsIgnoreCase(string) && string.equalsIgnoreCase("SM2")) {
                String string5 = ((ClearKeyParameter)hsmKeyParameter).getPublicKey();
                hashMap.put("pubStringKey", string5);
            }
        }
        catch (Exception exception) {
            throw new ParmErrorException("getPubicKeyFromCert:get PubicKey From Cert fail!" + exception.getMessage());
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsymmetricKeyParameter getPrivateKey(byte[] byArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        RSAKeyParameters rSAKeyParameters = null;
        BufferedReader bufferedReader = null;
        PrivateKeyInfo privateKeyInfo = null;
        try {
            object3 = new ByteArrayInputStream(byArray);
            bufferedReader = new PEMParser(new InputStreamReader((InputStream)object3));
            object2 = ((PEMParser)bufferedReader).readObject();
            if (object2 instanceof PrivateKeyInfo) {
                privateKeyInfo = (PrivateKeyInfo)object2;
                privateKeyInfo.getEncoded();
            }
            object = privateKeyInfo.parsePrivateKey();
            object.toASN1Primitive().getEncoded();
        }
        catch (Exception exception) {
            AsymmetricKeyParameter asymmetricKeyParameter = null;
            return asymmetricKeyParameter;
        }
        finally {
            bufferedReader.close();
        }
        try {
            object3 = KeyFactory.getInstance("RSA");
            object2 = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
            object = (java.security.interfaces.RSAPrivateKey)((KeyFactory)object3).generatePrivate((KeySpec)object2);
            if (object instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)object;
                rSAKeyParameters = new RSAPrivateCrtKeyParameters(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            } else if (object instanceof java.security.interfaces.RSAPrivateKey) {
                rSAKeyParameters = new RSAKeyParameters(true, object.getModulus(), object.getPrivateExponent());
            }
        }
        catch (Exception exception) {
            return null;
        }
        return rSAKeyParameters;
    }

    public static AsymmetricKeyParameter toAsymmetricKey(byte[] byArray, String string) throws Exception {
        if ("SM2private".equalsIgnoreCase(string)) {
            X9ECParameters x9ECParameters = GMNamedCurves.getByName("sm2p256v1");
            ECCurve eCCurve = x9ECParameters.getCurve();
            ECPoint eCPoint = x9ECParameters.getG();
            ECDomainParameters eCDomainParameters = new ECDomainParameters(eCCurve, eCPoint, eCCurve.getOrder());
            BigInteger bigInteger = new BigInteger(1, byArray);
            ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(bigInteger, eCDomainParameters);
            return eCPrivateKeyParameters;
        }
        if ("SM2public".equalsIgnoreCase(string)) {
            X9ECParameters x9ECParameters = GMNamedCurves.getByName("sm2p256v1");
            ECCurve eCCurve = x9ECParameters.getCurve();
            ECPoint eCPoint = x9ECParameters.getG();
            ECDomainParameters eCDomainParameters = new ECDomainParameters(eCCurve, eCPoint, eCCurve.getOrder());
            String string2 = Hex.toHexString(byArray);
            if (!string2.startsWith("04")) {
                throw new Exception("key data error!");
            }
            String string3 = string2.substring(2, 64);
            String string4 = string2.substring(66);
            ECPoint eCPoint2 = eCCurve.createPoint(new BigInteger(string3, 16), new BigInteger(string4, 16));
            ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(eCPoint2, eCDomainParameters);
            return eCPublicKeyParameters;
        }
        if ("RSAprivate".equalsIgnoreCase(string)) {
            RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(byArray);
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
            return rSAPrivateCrtKeyParameters;
        }
        if ("RSApublic".equalsIgnoreCase(string)) {
            RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(byArray);
            RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            return rSAKeyParameters;
        }
        throw new Exception("key type not support! " + string);
    }
}

