/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.journal;

import java.lang.reflect.Method;

public class LogProxy {
    private static final String className = LogProxy.class.getName();
    private static Object logObject = null;
    private static boolean slf4jLoggerFlag = false;
    private static boolean log4jLoggerFlag = false;

    public static synchronized void setLogObject(Object object) {
        logObject = object;
        if (object.getClass().getName().equalsIgnoreCase("org.apache.log4j.Logger")) {
            log4jLoggerFlag = true;
            slf4jLoggerFlag = false;
        }
        if (object.getClass().getName().startsWith("org.apache.logging.slf4j")) {
            log4jLoggerFlag = false;
            slf4jLoggerFlag = true;
        }
    }

    public static String getOccurPosition(StackTraceElement[] stackTraceElementArray) {
        String string = null;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!className.equalsIgnoreCase(stackTraceElementArray[i].getClassName())) continue;
            int n = i + 1;
            string = "at " + stackTraceElementArray[n].getClassName() + " " + stackTraceElementArray[n].getMethodName() + "() line no. " + stackTraceElementArray[n].getLineNumber();
            break;
        }
        return string;
    }

    public static void debug(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = LogProxy.getOccurPosition(stackTraceElementArray);
        String string3 = string2 + ": " + string;
        LogProxy.writeLog("debug", string3, null);
    }

    public static void debug(String string, Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = LogProxy.getOccurPosition(stackTraceElementArray);
        String string3 = string2 + ": " + string;
        LogProxy.writeLog("debug", string3, throwable);
    }

    public static void warn(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = LogProxy.getOccurPosition(stackTraceElementArray);
        String string3 = string2 + ": " + string;
        LogProxy.writeLog("warn", string3, null);
    }

    public static void warn(String string, Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = LogProxy.getOccurPosition(stackTraceElementArray);
        String string3 = string2 + ": " + string;
        LogProxy.writeLog("warn", string3, throwable);
    }

    public static void info(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = LogProxy.getOccurPosition(stackTraceElementArray);
        String string3 = string2 + ": " + string;
        LogProxy.writeLog("info", string3, null);
    }

    public static void info(String string, Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = LogProxy.getOccurPosition(stackTraceElementArray);
        String string3 = string2 + ": " + string;
        LogProxy.writeLog("info", string3, throwable);
    }

    public static void error(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = LogProxy.getOccurPosition(stackTraceElementArray);
        String string3 = string2 + ": " + string;
        LogProxy.writeLog("error", string3, null);
    }

    public static void error(String string, Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = LogProxy.getOccurPosition(stackTraceElementArray);
        String string3 = string2 + ": " + string;
        LogProxy.writeLog("error", string3, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLog(String string, String string2, Throwable throwable) {
        Object object;
        if (logObject == null) {
            object = className;
            synchronized (object) {
                if (logObject == null) {
                    Class<?> clazz = null;
                    Class<?> clazz2 = null;
                    Class<?> clazz3 = null;
                    try {
                        clazz = Class.forName("org.slf4j.Logger");
                        clazz2 = Class.forName("org.slf4j.LoggerFactory");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (clazz != null && clazz2 != null) {
                        try {
                            Method method = clazz2.getMethod("getLogger", String.class);
                            logObject = method.invoke(null, className);
                            slf4jLoggerFlag = true;
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            clazz3 = Class.forName("org.apache.log4j.Logger");
                            if (clazz3 != null) {
                                Method method = clazz3.getMethod("getLogger", String.class);
                                logObject = method.invoke(null, className);
                                log4jLoggerFlag = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (!("debug".equalsIgnoreCase(string) || "warn".equalsIgnoreCase(string) || "info".equalsIgnoreCase(string) || "error".equalsIgnoreCase(string))) {
            return;
        }
        try {
            if (throwable == null) {
                if (slf4jLoggerFlag) {
                    object = logObject.getClass().getMethod(string, String.class);
                    ((Method)object).invoke(logObject, string2);
                }
                if (log4jLoggerFlag) {
                    object = logObject.getClass().getMethod(string, Object.class);
                    ((Method)object).invoke(logObject, string2);
                }
            } else {
                if (slf4jLoggerFlag) {
                    object = logObject.getClass().getMethod(string, String.class, Throwable.class);
                    ((Method)object).invoke(logObject, string2, throwable);
                }
                if (log4jLoggerFlag) {
                    object = logObject.getClass().getMethod(string, Object.class, Throwable.class);
                    ((Method)object).invoke(logObject, string2, throwable);
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }
}

