/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.temp;

import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.icbc.hsm.software.basic.Signature;
import com.icbc.hsm.utils.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.security.cert.X509Certificate;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSignatureImpl {
    private static final Long version = -1L;
    private static HashMap<String, String> algMap = new HashMap();
    private String baseURI = null;
    private String defaultNamespacePrefix = null;
    private boolean insertCertificate = true;

    public static XmlSignatureImpl getInstance() throws Exception {
        return new XmlSignatureImpl();
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void setDefaultNamespacePrefix(String string) {
        this.defaultNamespacePrefix = string;
    }

    public void setInsertCertificate(boolean bl) {
        this.insertCertificate = bl;
    }

    public String generateDetachedXmlSignature(String string, String string2, String string3, PrivateKey privateKey, java.security.cert.X509Certificate x509Certificate) throws Exception {
        XMLStructure xMLStructure;
        String string4 = null;
        string4 = algMap.get(string2);
        String string5 = null;
        string5 = algMap.get(string3);
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)document);
        if (this.baseURI != null) {
            dOMSignContext.setBaseURI(this.baseURI);
        }
        if (this.defaultNamespacePrefix != null) {
            dOMSignContext.setDefaultNamespacePrefix(this.defaultNamespacePrefix);
        }
        dOMSignContext.setProperty("javax.xml.crypto.dsig.cacheReference", true);
        Reference reference = xMLSignatureFactory.newReference(string, xMLSignatureFactory.newDigestMethod(string4, null));
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, reference);
        SignedInfo signedInfo = xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod(string5, null), arrayList);
        KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance("DOM");
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (this.insertCertificate) {
            arrayList2.add(x509Certificate);
        } else {
            xMLStructure = keyInfoFactory.newX509IssuerSerial(x509Certificate.getIssuerDN().getName(), x509Certificate.getSerialNumber());
            arrayList2.add(x509Certificate.getSubjectDN().getName());
            arrayList2.add(xMLStructure);
        }
        xMLStructure = keyInfoFactory.newX509Data(arrayList2);
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(xMLStructure));
        XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo);
        xMLSignature.sign(dOMSignContext);
        System.out.println("ref.getDigestValue(): " + reference.getDigestValue());
        System.out.println("ref.getDigestInputStream(): " + reference.getDigestInputStream());
        System.out.println("si.getCanonicalizedData(): " + signedInfo.getCanonicalizedData());
        System.out.println("signature.getSignatureValue().getValue(): " + Base64.toBase64String(xMLSignature.getSignatureValue().getValue()));
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(true, ((RSAPrivateKey)privateKey).getModulus(), ((RSAPrivateKey)privateKey).getPrivateExponent());
        byte[] byArray = new byte[81920];
        int n = signedInfo.getCanonicalizedData().read(byArray);
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        String string6 = Base64.toBase64String(Signature.sign("SHA256withRSA", rSAKeyParameters, byArray2));
        System.out.println("newSignature SHA256withRSA:\n" + string6);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
        String string7 = byteArrayOutputStream.toString();
        return string7;
    }

    public static String generateXmlSignature(String string, String string2, String string3, PrivateKey privateKey, X509Certificate x509Certificate) throws Exception {
        String string4 = null;
        if ("SHA256".equalsIgnoreCase(string2)) {
            string4 = "http://www.w3.org/2001/04/xmlenc#sha256";
        } else if ("SHA512".equalsIgnoreCase(string2)) {
            string4 = "http://www.w3.org/2001/04/xmlenc#sha512";
        } else if ("SHA1".equalsIgnoreCase(string2)) {
            string4 = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        String string5 = null;
        if ("SHA256withRSA".equalsIgnoreCase(string3)) {
            string5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        } else if ("SHA1withRSA".equalsIgnoreCase(string3)) {
            string5 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else if ("SHA512withRSA".equalsIgnoreCase(string3)) {
            string5 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        }
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        DOMSignContext dOMSignContext = new DOMSignContext(privateKey, (Node)document.getDocumentElement());
        dOMSignContext.setProperty("javax.xml.crypto.dsig.cacheReference", true);
        Reference reference = xMLSignatureFactory.newReference(string, xMLSignatureFactory.newDigestMethod(string4, null));
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, reference);
        SignedInfo signedInfo = xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod(string5, null), arrayList);
        KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance("DOM");
        X509IssuerSerial x509IssuerSerial = keyInfoFactory.newX509IssuerSerial(x509Certificate.getIssuerDN().getName(), x509Certificate.getSerialNumber());
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(x509Certificate.getIssuerDN().getName());
        arrayList2.add(x509IssuerSerial);
        X509Data x509Data = keyInfoFactory.newX509Data(arrayList2);
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
        XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo);
        xMLSignature.sign(dOMSignContext);
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(true, ((RSAPrivateKey)privateKey).getModulus(), ((RSAPrivateKey)privateKey).getPrivateExponent());
        byte[] byArray = new byte[81920];
        int n = signedInfo.getCanonicalizedData().read(byArray);
        byte[] byArray2 = Arrays.copyOf(byArray, n);
        String string6 = Base64.toBase64String(Signature.sign("SHA256withRSA", rSAKeyParameters, byArray2));
        System.out.println("newSignature SHA256withRSA:\n" + string6);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(byteArrayOutputStream));
        String string7 = byteArrayOutputStream.toString();
        return string7;
    }

    public boolean validateXmlSignature(String string, java.security.cert.X509Certificate x509Certificate) throws Exception {
        boolean bl = false;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new FileInputStream(string));
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        DOMValidateContext dOMValidateContext = null;
        if (x509Certificate == null) {
            throw new Exception("x509cert is null");
        }
        dOMValidateContext = new DOMValidateContext(x509Certificate.getPublicKey(), nodeList.item(0));
        if (this.baseURI != null) {
            dOMValidateContext.setBaseURI(this.baseURI);
        }
        XMLSignature xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
        bl = xMLSignature.validate(dOMValidateContext);
        System.out.println("signature.validate(valContext): " + bl);
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = xMLSignature.getSignatureValue().validate(dOMValidateContext);
            stringBuilder.append("signature validation status: " + bl2 + "\n");
            Iterator<Reference> iterator = xMLSignature.getSignedInfo().getReferences().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                boolean bl3 = iterator.next().validate(dOMValidateContext);
                stringBuilder.append("ref[" + n + "] validity status: " + bl3 + "\n");
                ++n;
            }
            System.out.println(stringBuilder.toString());
        }
        return bl;
    }

    public static void test1() throws Exception {
        String string = "Password1!";
        string = "070-BULK-SIGN-UAT_20200518";
        String string2 = "icbc asia - ds, nr";
        string2 = "070-BULK-SIGN-UAT_20200518";
        String string3 = "E:\\21517039.p12";
        string3 = "E:\\xmlfiletest\\070-BULK-SIGN-UAT_20200518.jks";
        String string4 = "PKCS12";
        string4 = "jks";
        KeyStore keyStore = XmlSignatureImpl.getKeyStore(string3, string, string4);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string2, string.toCharArray());
        java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)keyStore.getCertificate(string2);
        XmlSignatureImpl xmlSignatureImpl = XmlSignatureImpl.getInstance();
        xmlSignatureImpl.setBaseURI("file:///E://xmlfiletest//");
        xmlSignatureImpl.setInsertCertificate(false);
        String string5 = xmlSignatureImpl.generateDetachedXmlSignature("070-20201220-OC-SDVA-00002-002.xml", "SHA256", "SHA256withRSA", privateKey, x509Certificate);
        System.out.println("=====================================================");
        System.out.println(string5);
        FileOutputStream fileOutputStream = null;
        String string6 = null;
        string6 = "E:\\test.xml.signature";
        string6 = "E:\\xmlfiletest\\signature.xml";
        fileOutputStream = new FileOutputStream(string6);
        ((OutputStream)fileOutputStream).write(string5.getBytes());
        ((OutputStream)fileOutputStream).close();
        boolean bl = xmlSignatureImpl.validateXmlSignature(string6, x509Certificate);
        System.out.println(bl);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getEncoded());
        java.security.cert.X509Certificate x509Certificate2 = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        string5 = xmlSignatureImpl.generateDetachedXmlSignature("file:///E://test.xml", "SHA256", "SHA256withRSA", privateKey, x509Certificate2);
        System.out.println(string5);
    }

    public static void main(String[] stringArray) throws Exception {
        XmlSignatureImpl.test1();
    }

    public static KeyStore getKeyStore(String string, String string2, String string3) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(string3);
        FileInputStream fileInputStream = new FileInputStream(string);
        keyStore.load(fileInputStream, string2.toCharArray());
        fileInputStream.close();
        return keyStore;
    }

    static {
        algMap.put("SHA256", "http://www.w3.org/2001/04/xmlenc#sha256");
        algMap.put("SHA512", "http://www.w3.org/2001/04/xmlenc#sha512");
        algMap.put("SHA1", "http://www.w3.org/2000/09/xmldsig#sha1");
        algMap.put("SHA256withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        algMap.put("SHA512withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        algMap.put("SHA1withRSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }
}

