/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.utils.encoders;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GF {
    public static byte[] bytesXor(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n && i < byArray2.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static String C2XS(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = String.format("%02X", by & 0xFF);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static byte[] X2CB(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length / 2];
        GF.X2C(byArray, byArray2);
        return byArray2;
    }

    public static String C2XS(String string, String string2) {
        String string3;
        try {
            byte[] byArray = GF.isBlank(string2) ? string.getBytes() : string.getBytes(string2);
            string3 = GF.C2XS(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = "UnsupportedEncodingException";
            unsupportedEncodingException.printStackTrace();
        }
        return string3;
    }

    public static String X2CS(String string, String string2) {
        String string3 = "Error~!";
        if (GF.isBlank(string)) {
            return string3;
        }
        int n = string.length();
        if (n % 2 != 0) {
            return string3;
        }
        byte[] byArray = new byte[n / 2];
        byte[] byArray2 = string.getBytes();
        if (GF.X2C(byArray2, byArray) >= 0) {
            try {
                string3 = GF.isBlank(string2) ? new String(byArray) : new String(byArray, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = "UnsupportedEncodingException";
                unsupportedEncodingException.printStackTrace();
            }
        }
        return string3;
    }

    public static String removeBlankTabEnter(String string) {
        return string.replaceAll("\\s{1,}", "").replaceAll("\n", "").replaceAll("\t", "");
    }

    public static int X2C(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        if (byArray3 == null || byArray4 == null) {
            return -20;
        }
        int n = byArray3.length;
        if (n < 2) {
            return -21;
        }
        if (n % 2 != 0) {
            return -22;
        }
        if (byArray4.length < n / 2) {
            return -23;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5;
            if ((n5 = GF.hex_to_num(byArray3[n2++])) < 0) {
                return -24;
            }
            if ((n4 = GF.hex_to_num(byArray3[n2++])) < 0) {
                return -24;
            }
            int n6 = (n5 << 4 | n4) & 0xFF;
            byArray4[n3] = (byte)n6;
            ++n3;
        }
        return n3;
    }

    private static int hex_to_num(byte by) {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return by - 65 + 10;
        }
        if (by >= 97 && by <= 102) {
            return by - 97 + 10;
        }
        return -1;
    }

    public static boolean isBlank(Object object) {
        boolean bl = false;
        if ("".equals(object) || object == null) {
            bl = true;
        }
        return bl;
    }

    public static byte[] oddParity(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            int n2 = byArray[i];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            String string = Integer.toBinaryString(n2);
            char[] cArray = string.toCharArray();
            int n3 = 0;
            for (n = 0; n < cArray.length; ++n) {
                if (cArray[n] != '1') continue;
                ++n3;
            }
            if (n3 % 2 != 0) continue;
            n = cArray[cArray.length - 1];
            cArray[cArray.length - 1] = n == 49 ? 48 : 49;
            string = String.valueOf(cArray);
            byArray[i] = (byte)Integer.parseInt(string, 2);
        }
        return byArray;
    }

    public static byte[] hexToByte(String string) throws Exception {
        byte[] byArray = new byte[]{};
        int n = string.length();
        if (n % 2 != 0) {
            throw new Exception("\u6570\u636e\u4e0d\u662f2\u7684\u6574\u6570\u500d");
        }
        byArray = new byte[n / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, (i + 1) * 2), 16);
        }
        return byArray;
    }

    public static byte[] XOR(String string, String string2) throws Exception {
        if (string.length() != string2.length()) {
            throw new Exception("two string length must be equal");
        }
        Pattern pattern = Pattern.compile("\\p{XDigit}*");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new Exception("string 1 data range:[0-9][a-f][A-F]");
        }
        matcher = pattern.matcher(string2);
        if (!matcher.matches()) {
            throw new Exception("string 2 data range:[0-9][a-f][A-F]");
        }
        byte[] byArray = GF.hexToByte(string);
        byte[] byArray2 = GF.hexToByte(string2);
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)((byArray[i] ^ byArray2[i]) & 0xFF);
        }
        return byArray3;
    }

    public static int checkData(String string, int n) {
        int n2 = string.length();
        if (n2 != n) {
            return -9006;
        }
        for (int i = 0; i < n2; ++i) {
            if (Character.digit(string.charAt(i), 16) >= 0) continue;
            return -9006;
        }
        return 0;
    }

    public static int parseInt(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1104;
        }
        return n;
    }

    public static String XOR(int n, String ... stringArray) {
        int n2;
        if (stringArray[0].length() % 2 != 0) {
            return "-1";
        }
        byte[] byArray = GF.X2CB(stringArray[0]);
        int n3 = byArray.length;
        byte[][] byArrayArray = new byte[n][];
        byte[] byArray2 = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray2[n2] = 0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            byArrayArray[n2] = GF.X2CB(stringArray[n2]);
            if (byArrayArray[n2].length == n3) continue;
            return "-2";
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n; ++i) {
                int n4 = n2;
                byArray2[n4] = (byte)(byArray2[n4] ^ byArrayArray[i][n2]);
            }
        }
        return GF.C2XS(byArray2);
    }

    public static String padString(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = stringBuilder.length();
        int n3 = n - n2;
        for (int i = 0; i < n3; ++i) {
            stringBuilder.insert(0, string2);
        }
        return stringBuilder.toString();
    }

    public static String padStringAfter(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = stringBuilder.length();
        int n3 = n - n2;
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String getCanonicalPath(String string) {
        String string2;
        try {
            File file = new File(string).getCanonicalFile();
            string2 = file.exists() ? file.getCanonicalPath() : new File(".." + File.separator + string).getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = null;
        }
        return string2;
    }

    public static boolean verifyHex(String string) {
        return !GF.isBlank(string) && string.matches("(\\p{XDigit}{2})+");
    }

    public static boolean verifyHex(String string, int n) {
        return !GF.isBlank(string) && string.matches("(\\p{XDigit}{" + n + "})");
    }

    public static boolean verifyNumberAndLength(String string, int n) {
        return !GF.isBlank(string) && string.matches("\\d{" + n + "}");
    }

    public static boolean verifyNumber(String string, int n) {
        return !GF.isBlank(string) && string.matches("\\d{" + n + "}");
    }

    public static boolean verifyNumber(String string, int n, int n2) {
        return !GF.isBlank(string) && string.matches("\\d*") && string.length() >= n && string.length() <= n2;
    }

    public static boolean verifyNumber(String string) {
        return !GF.isBlank(string) && string.matches("\\d*");
    }

    public static boolean verifyBase64(String string) {
        return !GF.isBlank(string) && string.matches("[\\p{Alnum}+/]+[=]{0,2}");
    }

    public static boolean verifyString(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyLetterDigit(String string) {
        return !GF.isBlank(string) && string.matches("^[a-z0-9A-Z]+$");
    }
}

