/*
 * Decompiled with CFR 0.152.
 */
package cn.sm2_cert_parse;

import cn.win_trust_erpc.bouncycastle.crypto.digests.GeneralDigest;
import cn.win_trust_erpc.bouncycastle.util.Memoable;
import cn.win_trust_erpc.bouncycastle.util.Pack;

public class SM3Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 32;
    private static final int BLOCK_SIZE = 16;
    private int[] V = new int[8];
    private int[] inwords = new int[16];
    private int xOff;
    private int[] W = new int[68];
    private int[] W1 = new int[64];
    private static final int[] T = new int[64];

    static {
        int i = 0;
        while (i < 16) {
            int t = 2043430169;
            SM3Digest.T[i] = t << i | t >>> 32 - i;
            ++i;
        }
        i = 16;
        while (i < 64) {
            int n = i % 32;
            int t = 2055708042;
            SM3Digest.T[i] = t << n | t >>> 32 - n;
            ++i;
        }
    }

    public SM3Digest() {
        this.reset();
    }

    public SM3Digest(SM3Digest t) {
        super(t);
        this.copyIn(t);
    }

    private void copyIn(SM3Digest t) {
        System.arraycopy(t.V, 0, this.V, 0, this.V.length);
        System.arraycopy(t.inwords, 0, this.inwords, 0, this.inwords.length);
        this.xOff = t.xOff;
    }

    @Override
    public String getAlgorithmName() {
        return "SM3";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void reset() {
        super.reset();
        this.V[0] = 1937774191;
        this.V[1] = 1226093241;
        this.V[2] = 388252375;
        this.V[3] = -628488704;
        this.V[4] = -1452330820;
        this.V[5] = 372324522;
        this.V[6] = -477237683;
        this.V[7] = -1325724082;
        this.xOff = 0;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.finish();
        Pack.intToBigEndian(this.V[0], out, outOff + 0);
        Pack.intToBigEndian(this.V[1], out, outOff + 4);
        Pack.intToBigEndian(this.V[2], out, outOff + 8);
        Pack.intToBigEndian(this.V[3], out, outOff + 12);
        Pack.intToBigEndian(this.V[4], out, outOff + 16);
        Pack.intToBigEndian(this.V[5], out, outOff + 20);
        Pack.intToBigEndian(this.V[6], out, outOff + 24);
        Pack.intToBigEndian(this.V[7], out, outOff + 28);
        this.reset();
        return 32;
    }

    @Override
    protected void processWord(byte[] in, int inOff) {
        int n;
        this.inwords[this.xOff] = n = (in[inOff] & 0xFF) << 24 | (in[++inOff] & 0xFF) << 16 | (in[++inOff] & 0xFF) << 8 | in[++inOff] & 0xFF;
        ++this.xOff;
        if (this.xOff >= 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
            this.processBlock();
        }
        while (this.xOff < 14) {
            this.inwords[this.xOff] = 0;
            ++this.xOff;
        }
        this.inwords[this.xOff++] = (int)(bitLength >>> 32);
        this.inwords[this.xOff++] = (int)bitLength;
    }

    private int P0(int x) {
        int r9 = x << 9 | x >>> 23;
        int r17 = x << 17 | x >>> 15;
        return x ^ r9 ^ r17;
    }

    private int P1(int x) {
        int r15 = x << 15 | x >>> 17;
        int r23 = x << 23 | x >>> 9;
        return x ^ r15 ^ r23;
    }

    private int FF0(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private int FF1(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private int GG0(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private int GG1(int x, int y, int z) {
        return x & y | ~x & z;
    }

    @Override
    protected void processBlock() {
        int TT2;
        int TT1;
        int SS2;
        int SS1;
        int s1_;
        int a12;
        int j = 0;
        while (j < 16) {
            this.W[j] = this.inwords[j];
            ++j;
        }
        j = 16;
        while (j < 68) {
            int wj3 = this.W[j - 3];
            int r15 = wj3 << 15 | wj3 >>> 17;
            int wj13 = this.W[j - 13];
            int r7 = wj13 << 7 | wj13 >>> 25;
            this.W[j] = this.P1(this.W[j - 16] ^ this.W[j - 9] ^ r15) ^ r7 ^ this.W[j - 6];
            ++j;
        }
        j = 0;
        while (j < 64) {
            this.W1[j] = this.W[j] ^ this.W[j + 4];
            ++j;
        }
        int A = this.V[0];
        int B = this.V[1];
        int C = this.V[2];
        int D = this.V[3];
        int E = this.V[4];
        int F2 = this.V[5];
        int G = this.V[6];
        int H = this.V[7];
        int j2 = 0;
        while (j2 < 16) {
            a12 = A << 12 | A >>> 20;
            s1_ = a12 + E + T[j2];
            SS1 = s1_ << 7 | s1_ >>> 25;
            SS2 = SS1 ^ a12;
            TT1 = this.FF0(A, B, C) + D + SS2 + this.W1[j2];
            TT2 = this.GG0(E, F2, G) + H + SS1 + this.W[j2];
            D = C;
            C = B << 9 | B >>> 23;
            B = A;
            A = TT1;
            H = G;
            G = F2 << 19 | F2 >>> 13;
            F2 = E;
            E = this.P0(TT2);
            ++j2;
        }
        j2 = 16;
        while (j2 < 64) {
            a12 = A << 12 | A >>> 20;
            s1_ = a12 + E + T[j2];
            SS1 = s1_ << 7 | s1_ >>> 25;
            SS2 = SS1 ^ a12;
            TT1 = this.FF1(A, B, C) + D + SS2 + this.W1[j2];
            TT2 = this.GG1(E, F2, G) + H + SS1 + this.W[j2];
            D = C;
            C = B << 9 | B >>> 23;
            B = A;
            A = TT1;
            H = G;
            G = F2 << 19 | F2 >>> 13;
            F2 = E;
            E = this.P0(TT2);
            ++j2;
        }
        this.V[0] = this.V[0] ^ A;
        this.V[1] = this.V[1] ^ B;
        this.V[2] = this.V[2] ^ C;
        this.V[3] = this.V[3] ^ D;
        this.V[4] = this.V[4] ^ E;
        this.V[5] = this.V[5] ^ F2;
        this.V[6] = this.V[6] ^ G;
        this.V[7] = this.V[7] ^ H;
        this.xOff = 0;
    }

    @Override
    public Memoable copy() {
        return null;
    }

    @Override
    public void reset(Memoable other) {
    }
}

