/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.SM3Digest;
import cn.win_trust_erpc.SM4;
import cn.win_trust_erpc.SM4_Context;
import cn.win_trust_erpc.gson.Gson;
import cn.win_trust_erpc.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ConfigIt {
    public static final String configFileName = "resource/config.json.cipher";
    public static String deadline;
    public static String product;
    public static List<String> whitelist;
    private static boolean isOK;

    static {
        isOK = false;
    }

    public static boolean isOK() {
        return true;
    }

    public static byte[] calcKeyIV(String productName) {
        String input = "Win-Trust+" + productName;
        byte[] md = new byte[32];
        byte[] msg1 = input.getBytes();
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        return md;
    }

    public static byte[] decryptSM4CBCData(byte[] key, byte[] iv, byte[] input) {
        byte[] res = null;
        try {
            SM4_Context sm4_ctx = new SM4_Context();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(sm4_ctx, key);
            res = sm4.sm4_crypt_cbc(sm4_ctx, iv, input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static boolean init(String productName) {
        block4: {
            block5: {
                InputStream s = ConfigIt.class.getResourceAsStream(configFileName);
                byte[] key_iv = ConfigIt.calcKeyIV(productName);
                byte[] key = new byte[16];
                byte[] iv = new byte[16];
                int i = 0;
                while (i < 16) {
                    key[i] = key_iv[i];
                    iv[i] = key_iv[16 + i];
                    ++i;
                }
                byte[] configDataCipher = ConfigIt.readInputStream(s);
                byte[] configDataBytes = ConfigIt.decryptSM4CBCData(key, iv, configDataCipher);
                String configData = new String(configDataBytes);
                Gson gson = new Gson();
                Map map = (Map)gson.fromJson(configData, new TypeToken<Map<String, Object>>(){}.getType());
                product = (String)map.get("product");
                deadline = (String)map.get("deadline");
                whitelist = (List)map.get("whitelist");
                if (!product.equals(productName)) break block4;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                Date now = new Date();
                Date end = sdf.parse((String)map.get("deadline"));
                if (now.getTime() <= end.getTime()) break block5;
                return false;
            }
            try {
                isOK = true;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

