/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.ConfigIt;
import cn.win_trust_erpc.SM2Utils;
import cn.win_trust_erpc.SM3HMac;
import cn.win_trust_erpc.SM4;
import cn.win_trust_erpc.SM4_Context;
import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.WEC;
import com.union.api.TUnionTransInfo;
import com.union.api.UnionEsscAPI;
import com.union.api.UnionStr;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class WECImp16Hmac
implements WEC {
    private byte[] m_key;
    List<String> ipList;
    List<Integer> portList;
    int timeout;
    String sysID;
    String appID;
    String keyName;
    int vkIndex;

    @Override
    public byte[] GenExportSessionKey(byte[] sm2Pubkey) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        Random rd = new Random();
        byte[] keyAll = new byte[16];
        rd.nextBytes(keyAll);
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return SM2Utils.encrypt(sm2Pubkey, keyAll);
    }

    public static byte[] switch_c3_after_c2(byte[] cipher) {
        byte[] c1 = new byte[65];
        byte[] c2 = new byte[cipher.length - 65 - 32];
        byte[] c3 = new byte[32];
        System.arraycopy(cipher, 0, c1, 0, 65);
        System.arraycopy(cipher, 65, c3, 0, 32);
        System.arraycopy(cipher, 97, c2, 0, cipher.length - 65 - 32);
        byte[] cipherNew = new byte[cipher.length];
        System.arraycopy(c1, 0, cipherNew, 0, c1.length);
        System.arraycopy(c2, 0, cipherNew, c1.length, c2.length);
        System.arraycopy(c3, 0, cipherNew, c1.length + c2.length, c3.length);
        return cipherNew;
    }

    public static byte[] switch_c3_before_c2(byte[] cipher) {
        byte[] c1 = new byte[65];
        byte[] c2 = new byte[cipher.length - 65 - 32];
        byte[] c3 = new byte[32];
        System.arraycopy(cipher, 0, c1, 0, 65);
        System.arraycopy(cipher, 65, c2, 0, cipher.length - 65 - 32);
        System.arraycopy(cipher, cipher.length - 32, c3, 0, 32);
        byte[] cipherNew = new byte[cipher.length];
        System.arraycopy(c1, 0, cipherNew, 0, c1.length);
        System.arraycopy(c3, 0, cipherNew, c1.length, c3.length);
        System.arraycopy(c2, 0, cipherNew, c1.length + c3.length, c2.length);
        return cipherNew;
    }

    public boolean SetTUnionParam(List<String> ipList, List<Integer> portList, int timeout, String sysID, String appID, String keyName, int vkIndex) {
        this.ipList = ipList;
        this.portList = portList;
        this.timeout = timeout;
        this.sysID = sysID;
        this.appID = appID;
        this.keyName = keyName;
        this.vkIndex = vkIndex;
        return true;
    }

    public boolean ImportSessionKeyTUnion(byte[] keyCipher) throws Exception {
        keyCipher = WECImp16Hmac.switch_c3_before_c2(keyCipher);
        String cipherSKeyHex = Util.byteToHex(keyCipher);
        cipherSKeyHex = cipherSKeyHex.substring(2, cipherSKeyHex.length());
        UnionEsscAPI shortApi = new UnionEsscAPI(this.ipList, this.portList, this.timeout, this.sysID, this.appID);
        TUnionTransInfo info = shortApi.unionAPIServiceE173(this.keyName, String.valueOf(keyCipher.length), this.vkIndex, "SM2", "00", cipherSKeyHex);
        if (1 != info.getIsSuccess()) {
            return false;
        }
        System.out.println("1< " + info.getReturnBody().getPlainData());
        byte[] keyAll = UnionStr.aschex_to_bcdhex((String)info.getReturnBody().getPlainData());
        System.out.println("2< " + Util.byteToHex(keyAll));
        if (keyAll == null || keyAll.length != 16) {
            return false;
        }
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return true;
    }

    @Override
    public byte[] GenExportSessionKey(byte[] sm2Pubkey, boolean c1c3c2) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        Random rd = new Random();
        byte[] keyAll = new byte[16];
        rd.nextBytes(keyAll);
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return SM2Utils.encrypt(sm2Pubkey, keyAll, c1c3c2);
    }

    @Override
    public boolean ImportSessionKey(byte[] sm2Prvkey, byte[] keyCipher, boolean c1c3c2) throws Exception {
        byte[] keyAll = SM2Utils.decrypt(sm2Prvkey, keyCipher, c1c3c2);
        if (keyAll == null || keyAll.length != 16) {
            return false;
        }
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return true;
    }

    @Override
    public boolean ImportSessionKey(byte[] keyPlain) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] keyAll = keyPlain;
        if (keyAll == null || keyAll.length != 16) {
            return false;
        }
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return true;
    }

    @Override
    public boolean ImportSessionKey(byte[] sm2Prvkey, byte[] keyCipher) throws Exception {
        byte[] keyAll = SM2Utils.decrypt(sm2Prvkey, keyCipher);
        if (keyAll == null || keyAll.length != 16) {
            return false;
        }
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return true;
    }

    @Override
    public byte[] EncryptData(byte[] plainData) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        byte[] m_mackey = this.generateKey(this.m_key, "MAC".getBytes());
        byte[] m_enckey = this.generateKey(this.m_key, "ENC".getBytes());
        byte[] hmac = SM3HMac.SM3HashMac(plainData, m_mackey);
        sm4.sm4_setkey_enc(ctx, m_enckey);
        cipher = sm4.sm4_crypt_ecb(ctx, plainData);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        return res;
    }

    public byte[] generateKey(byte[] key, byte[] input) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] cipher = null;
        sm4.sm4_setkey_enc(ctx, key);
        cipher = sm4.sm4_crypt_ecb(ctx, input);
        return cipher;
    }

    @Override
    public byte[] DecryptData(byte[] encryptedData) throws Exception {
        SM4_Context ctx = new SM4_Context();
        SM4 sm4 = new SM4();
        byte[] plain = null;
        byte[] hmac = new byte[32];
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        byte[] m_mackey = this.generateKey(this.m_key, "MAC".getBytes());
        byte[] m_enckey = this.generateKey(this.m_key, "ENC".getBytes());
        System.arraycopy(encryptedData, 0, hmac, 0, 32);
        System.arraycopy(encryptedData, 32, tmp, 0, encryptedData.length - hmac.length);
        sm4.sm4_setkey_dec(ctx, m_enckey);
        plain = sm4.sm4_crypt_ecb(ctx, tmp);
        byte[] hmacTrans = SM3HMac.SM3HashMac(plain, m_mackey);
        if (Arrays.equals(hmacTrans, hmac)) {
            return plain;
        }
        return null;
    }

    public static void main1(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        WECImp16Hmac cryptoSend = new WECImp16Hmac();
        WECImp16Hmac cryptoRecv = new WECImp16Hmac();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(Util.hexToByte(pubk));
        boolean bImport = cryptoRecv.ImportSessionKey(Util.hexToByte(prik), keyCipher);
        System.out.println(bImport);
        byte[] plainData = "Hello World!".getBytes();
        byte[] encryptedData = cryptoSend.EncryptData(plainData);
        plainData = cryptoRecv.DecryptData(encryptedData);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptData(plainData);
        plainData = cryptoRecv.DecryptData(encryptedData);
        System.out.println(new String(plainData));
    }

    public static void main(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        WECImp16Hmac cryptoSend = new WECImp16Hmac();
        WECImp16Hmac cryptoRecv = new WECImp16Hmac();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(Util.hexToByte(pubk), true);
        keyCipher = WECImp16Hmac.switch_c3_after_c2(keyCipher);
        keyCipher = WECImp16Hmac.switch_c3_before_c2(keyCipher);
        byte[] keyPlain = SM2Utils.decrypt(Util.hexToByte(prik), keyCipher, true);
        boolean bImport = cryptoRecv.ImportSessionKey(keyPlain);
        System.out.println(bImport);
        byte[] plainData = "Hello World!".getBytes();
        byte[] encryptedData = cryptoSend.EncryptData(plainData);
        plainData = cryptoRecv.DecryptData(encryptedData);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptData(plainData);
        plainData = cryptoRecv.DecryptData(encryptedData);
        System.out.println(new String(plainData));
    }
}

