/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.ConfigIt;
import cn.win_trust_erpc.SM2Utils;
import cn.win_trust_erpc.SM3HMac;
import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.WEC;
import cn.win_trust_erpc.bouncycastle.crypto.BlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.BufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.engines.SM4Engine;
import cn.win_trust_erpc.bouncycastle.crypto.modes.CBCBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.paddings.PKCS7Padding;
import cn.win_trust_erpc.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithIV;
import com.union.api.TUnionTransInfo;
import com.union.api.UnionEsscAPI;
import com.union.api.UnionStr;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class WECImp32Hmac
implements WEC {
    private byte[] m_key;
    List<String> ipList;
    List<Integer> portList;
    int timeout;
    String sysID;
    String appID;
    String keyName;
    int vkIndex;

    public static byte[] SM4Crypt(byte[] key, byte[] iv, boolean encrypt, boolean useCBC, byte[] input) throws Exception {
        BlockCipher blockCipher = null;
        PaddedBufferedBlockCipher bufferedBlockCipher = null;
        if (useCBC) {
            blockCipher = new CBCBlockCipher(new SM4Engine());
            bufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
            ((BufferedBlockCipher)bufferedBlockCipher).init(encrypt, new ParametersWithIV(new KeyParameter(key), iv));
        } else {
            blockCipher = new SM4Engine();
            bufferedBlockCipher = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
            ((BufferedBlockCipher)bufferedBlockCipher).init(encrypt, new KeyParameter(key));
        }
        byte[] output = new byte[((BufferedBlockCipher)bufferedBlockCipher).getOutputSize(input.length)];
        int processed = ((BufferedBlockCipher)bufferedBlockCipher).processBytes(input, 0, input.length, output, 0);
        int finaled = ((BufferedBlockCipher)bufferedBlockCipher).doFinal(output, processed);
        byte[] res = new byte[processed + finaled];
        System.arraycopy(output, 0, res, 0, res.length);
        return res;
    }

    public boolean SetTUnionParam(List<String> ipList, List<Integer> portList, int timeout, String sysID, String appID, String keyName, int vkIndex) {
        this.ipList = ipList;
        this.portList = portList;
        this.timeout = timeout;
        this.sysID = sysID;
        this.appID = appID;
        this.keyName = keyName;
        this.vkIndex = vkIndex;
        return true;
    }

    public boolean ImportSessionKeyTUnion(byte[] keyCipher) throws Exception {
        String cipherSKeyHex = Util.byteToHex(keyCipher);
        UnionEsscAPI shortApi = new UnionEsscAPI(this.ipList, this.portList, this.timeout, this.sysID, this.appID);
        TUnionTransInfo info = shortApi.unionAPIServiceE173(this.keyName, String.valueOf(keyCipher.length), this.vkIndex, "SM2", "00", cipherSKeyHex);
        if (1 != info.getIsSuccess()) {
            return false;
        }
        System.out.println("1< " + info.getReturnBody().getPlainData());
        byte[] keyAll = UnionStr.aschex_to_bcdhex((String)info.getReturnBody().getPlainData());
        System.out.println("2< " + Util.byteToHex(keyAll));
        if (keyAll == null || keyAll.length != 16) {
            return false;
        }
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return true;
    }

    @Override
    public byte[] GenExportSessionKey(byte[] sm2Pubkey, boolean c1c3c2) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        Random rd = new Random();
        byte[] keyAll = new byte[16];
        rd.nextBytes(keyAll);
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        byte[] sessionKeyCipher04 = SM2Utils.encrypt(sm2Pubkey, keyAll, c1c3c2);
        byte[] sessionKeyCipher = new byte[sessionKeyCipher04.length - 1];
        System.arraycopy(sessionKeyCipher04, 1, sessionKeyCipher, 0, sessionKeyCipher.length);
        return sessionKeyCipher;
    }

    @Override
    public byte[] GenExportSessionKey(byte[] sm2Pubkey) throws Exception {
        return this.GenExportSessionKey(sm2Pubkey, true);
    }

    @Override
    public boolean ImportSessionKey(byte[] sm2Prvkey, byte[] keyCipher, boolean c1c3c2) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] sessionKeyCipher04 = new byte[keyCipher.length + 1];
        sessionKeyCipher04[0] = 4;
        System.arraycopy(keyCipher, 0, sessionKeyCipher04, 1, keyCipher.length);
        byte[] keyAll = SM2Utils.decrypt(sm2Prvkey, sessionKeyCipher04, c1c3c2);
        if (keyAll == null || keyAll.length != 16) {
            return false;
        }
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return true;
    }

    @Override
    public boolean ImportSessionKey(byte[] keyPlain) throws Exception {
        if (!ConfigIt.isOK()) {
            throw new Exception(" expire date!!!");
        }
        byte[] keyAll = keyPlain;
        if (keyAll == null || keyAll.length != 16) {
            return false;
        }
        this.m_key = new byte[16];
        System.arraycopy(keyAll, 0, this.m_key, 0, 16);
        return true;
    }

    @Override
    public boolean ImportSessionKey(byte[] sm2Prvkey, byte[] keyCipher) throws Exception {
        return this.ImportSessionKey(sm2Prvkey, keyCipher, true);
    }

    public boolean ImportSessionKeyC1C3C2(byte[] sm2Prvkey, byte[] keyCipher) throws Exception {
        return this.ImportSessionKey(sm2Prvkey, keyCipher, true);
    }

    @Override
    public byte[] EncryptData(byte[] plainData) throws Exception {
        byte[] cipher = null;
        byte[] m_mackey1 = this.generateKey(this.m_key, "MAC1".getBytes());
        byte[] m_mackey2 = this.generateKey(this.m_key, "MAC2".getBytes());
        byte[] m_mackey = new byte[m_mackey1.length + m_mackey2.length];
        System.arraycopy(m_mackey1, 0, m_mackey, 0, 16);
        System.arraycopy(m_mackey2, 0, m_mackey, 16, 16);
        byte[] m_enckey = this.generateKey(this.m_key, "ENC".getBytes());
        byte[] hmac = SM3HMac.SM3HashMac(plainData, m_mackey);
        cipher = WECImp32Hmac.SM4Crypt(m_enckey, null, true, false, plainData);
        byte[] res = new byte[hmac.length + cipher.length];
        System.arraycopy(hmac, 0, res, 0, hmac.length);
        System.arraycopy(cipher, 0, res, hmac.length, cipher.length);
        return res;
    }

    public byte[] generateKey(byte[] key, byte[] input) throws Exception {
        return WECImp32Hmac.SM4Crypt(key, null, true, false, input);
    }

    @Override
    public byte[] DecryptData(byte[] encryptedData) throws Exception {
        byte[] plain = null;
        byte[] hmac = new byte[32];
        byte[] tmp = new byte[encryptedData.length - hmac.length];
        byte[] m_mackey1 = this.generateKey(this.m_key, "MAC1".getBytes());
        byte[] m_mackey2 = this.generateKey(this.m_key, "MAC2".getBytes());
        byte[] m_mackey = new byte[m_mackey1.length + m_mackey2.length];
        System.arraycopy(m_mackey1, 0, m_mackey, 0, 16);
        System.arraycopy(m_mackey2, 0, m_mackey, 16, 16);
        byte[] m_enckey = this.generateKey(this.m_key, "ENC".getBytes());
        System.arraycopy(encryptedData, 0, hmac, 0, 32);
        System.arraycopy(encryptedData, 32, tmp, 0, encryptedData.length - hmac.length);
        plain = WECImp32Hmac.SM4Crypt(m_enckey, null, false, false, tmp);
        byte[] hmacTrans = SM3HMac.SM3HashMac(plain, m_mackey);
        if (Arrays.equals(hmacTrans, hmac)) {
            return plain;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        WECImp32Hmac cryptoSend = new WECImp32Hmac();
        WECImp32Hmac cryptoRecv = new WECImp32Hmac();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(Util.hexToByte(pubk));
        boolean bImport = cryptoRecv.ImportSessionKeyC1C3C2(Util.hexToByte(prik), keyCipher);
        System.out.println(bImport);
        byte[] plainData = "Hello World!".getBytes();
        byte[] encryptedData = cryptoSend.EncryptData(plainData);
        plainData = cryptoRecv.DecryptData(encryptedData);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptData(plainData);
        plainData = cryptoRecv.DecryptData(encryptedData);
        System.out.println(new String(plainData));
    }

    public static void main2(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        WECImp32Hmac cryptoSend = new WECImp32Hmac();
        WECImp32Hmac cryptoRecv = new WECImp32Hmac();
        byte[] keyCipher = cryptoSend.GenExportSessionKey(Util.hexToByte(pubk));
        byte[] keyCipherNew = new byte[keyCipher.length + 1];
        keyCipherNew[0] = 4;
        System.arraycopy(keyCipher, 0, keyCipherNew, 1, keyCipher.length);
        byte[] keyPlain = SM2Utils.decrypt(Util.hexToByte(prik), keyCipherNew, true);
        boolean bImport = cryptoRecv.ImportSessionKey(keyPlain);
        System.out.println(bImport);
        byte[] plainData = "Hello World!".getBytes();
        byte[] encryptedData = cryptoSend.EncryptData(plainData);
        plainData = cryptoRecv.DecryptData(encryptedData);
        System.out.println(new String(plainData));
        encryptedData = cryptoSend.EncryptData(plainData);
        plainData = cryptoRecv.DecryptData(encryptedData);
        System.out.println(new String(plainData));
    }

    public static void main3(String[] args) throws Exception {
        ConfigIt.init("wt");
        String prik = "5FAC6917673D6C8340E13F465C6F9E5A4954FF9AEF73EB03DFB85F0450517291";
        WECImp32Hmac cryptoRecv = new WECImp32Hmac();
        byte[] keyCipher = Util.hexToByte("177D5B571892A4AB156563243367BD5D331B23766617768876473BB1B8178466A8FA5AD3584A4D83693D3ABAA58CD145D5B2A6C9461CFA31F1BD4F7945ABA78C0226897BBD74B454C80DA0707628A75575305AF3E8623959D958873A0A67F23A9116C54A934F1067BC9940D46509111F");
        boolean bImport = cryptoRecv.ImportSessionKey(Util.hexToByte(prik), keyCipher, false);
        System.out.println(bImport);
        byte[] plainData = cryptoRecv.DecryptData(Util.hexToByte("75A29AA149D65EB9C6988123E3D4157B4B7988E1ED51EAA49367D67DF3C3E8D0E7020B2C196C8895113A1CA244159F888C9197AD589786BFF97914E5324D5866DA5CC6E693969B2BA686F6BC41B9196F"));
        System.out.println(new String(plainData));
    }
}

