/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1BitStringParser;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ParsingException;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1StreamParser;
import cn.win_trust_erpc.bouncycastle.asn1.BERBitString;
import cn.win_trust_erpc.bouncycastle.asn1.ConstructedBitStream;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;

public class BERBitStringParser
implements ASN1BitStringParser {
    private ASN1StreamParser _parser;
    private ConstructedBitStream _bitStream;

    BERBitStringParser(ASN1StreamParser parser) {
        this._parser = parser;
    }

    @Override
    public InputStream getOctetStream() throws IOException {
        this._bitStream = new ConstructedBitStream(this._parser, true);
        return this._bitStream;
    }

    @Override
    public InputStream getBitStream() throws IOException {
        this._bitStream = new ConstructedBitStream(this._parser, false);
        return this._bitStream;
    }

    @Override
    public int getPadBits() {
        return this._bitStream.getPadBits();
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        return BERBitStringParser.parse(this._parser);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException e) {
            throw new ASN1ParsingException("IOException converting stream to byte array: " + e.getMessage(), e);
        }
    }

    static BERBitString parse(ASN1StreamParser sp) throws IOException {
        ConstructedBitStream bitStream = new ConstructedBitStream(sp, false);
        byte[] data = Streams.readAll(bitStream);
        int padBits = bitStream.getPadBits();
        return new BERBitString(data, padBits);
    }
}

