/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1.cmp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1BitString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1TaggedObject;
import cn.win_trust_erpc.bouncycastle.asn1.DERBitString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.DERTaggedObject;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.CMPCertificate;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIBody;
import cn.win_trust_erpc.bouncycastle.asn1.cmp.PKIHeader;
import java.util.Enumeration;

public class PKIMessage
extends ASN1Object {
    private PKIHeader header;
    private PKIBody body;
    private ASN1BitString protection;
    private ASN1Sequence extraCerts;

    private PKIMessage(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.header = PKIHeader.getInstance(en.nextElement());
        this.body = PKIBody.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            if (tObj.getTagNo() == 0) {
                this.protection = DERBitString.getInstance(tObj, true);
                continue;
            }
            this.extraCerts = ASN1Sequence.getInstance(tObj, true);
        }
    }

    public static PKIMessage getInstance(Object o) {
        if (o instanceof PKIMessage) {
            return (PKIMessage)o;
        }
        if (o != null) {
            return new PKIMessage(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public PKIMessage(PKIHeader header, PKIBody body2, ASN1BitString protection, CMPCertificate[] extraCerts) {
        this.header = header;
        this.body = body2;
        this.protection = protection;
        if (extraCerts != null) {
            this.extraCerts = new DERSequence(extraCerts);
        }
    }

    public PKIMessage(PKIHeader header, PKIBody body2, ASN1BitString protection) {
        this(header, body2, protection, null);
    }

    public PKIMessage(PKIHeader header, PKIBody body2) {
        this(header, body2, null, null);
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public ASN1BitString getProtection() {
        return this.protection;
    }

    public CMPCertificate[] getExtraCerts() {
        if (this.extraCerts == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.extraCerts.size()];
        int i = 0;
        while (i < results.length) {
            results[i] = CMPCertificate.getInstance(this.extraCerts.getObjectAt(i));
            ++i;
        }
        return results;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(4);
        v.add(this.header);
        v.add(this.body);
        this.addOptional(v, 0, this.protection);
        this.addOptional(v, 1, this.extraCerts);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

