/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1.tsp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1OctetString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.DEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.util.Enumeration;

public class PartialHashtree
extends ASN1Object {
    private final ASN1Sequence values;

    public static PartialHashtree getInstance(Object obj) {
        if (obj instanceof PartialHashtree) {
            return (PartialHashtree)obj;
        }
        if (obj != null) {
            return new PartialHashtree(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PartialHashtree(ASN1Sequence values) {
        int i = 0;
        while (i != values.size()) {
            if (!(values.getObjectAt(i) instanceof DEROctetString)) {
                throw new IllegalArgumentException("unknown object in constructor: " + values.getObjectAt(i).getClass().getName());
            }
            ++i;
        }
        this.values = values;
    }

    public PartialHashtree(byte[] values) {
        this(new byte[][]{values});
    }

    public PartialHashtree(byte[][] values) {
        ASN1EncodableVector v = new ASN1EncodableVector(values.length);
        int i = 0;
        while (i != values.length) {
            v.add(new DEROctetString(Arrays.clone(values[i])));
            ++i;
        }
        this.values = new DERSequence(v);
    }

    public int getValueCount() {
        return this.values.size();
    }

    public byte[][] getValues() {
        byte[][] rv = new byte[this.values.size()][];
        int i = 0;
        while (i != rv.length) {
            rv[i] = Arrays.clone(ASN1OctetString.getInstance(this.values.getObjectAt(i)).getOctets());
            ++i;
        }
        return rv;
    }

    public boolean containsHash(byte[] hash) {
        Enumeration hashes = this.values.getObjects();
        while (hashes.hasMoreElements()) {
            byte[] currentHash = ASN1OctetString.getInstance(hashes.nextElement()).getOctets();
            if (!Arrays.constantTimeAreEqual(hash, currentHash)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.values;
    }
}

