/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cert.crmf;

import cn.win_trust_erpc.bouncycastle.asn1.cmp.PBMParameter;
import cn.win_trust_erpc.bouncycastle.asn1.crmf.PKMACValue;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.cert.crmf.CRMFException;
import cn.win_trust_erpc.bouncycastle.cert.crmf.PKMACBuilder;
import cn.win_trust_erpc.bouncycastle.operator.MacCalculator;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return Arrays.constantTimeAreEqual(calculator.getMac(), value.getValue().getBytes());
    }
}

