/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cert.dane;

import cn.win_trust_erpc.bouncycastle.cert.dane.DANEEntrySelector;
import cn.win_trust_erpc.bouncycastle.cert.dane.DANEException;
import cn.win_trust_erpc.bouncycastle.operator.DigestCalculator;
import cn.win_trust_erpc.bouncycastle.util.Strings;
import cn.win_trust_erpc.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.io.OutputStream;

public class DANEEntrySelectorFactory {
    private final DigestCalculator digestCalculator;

    public DANEEntrySelectorFactory(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    public DANEEntrySelector createSelector(String emailAddress) throws DANEException {
        byte[] enc = Strings.toUTF8ByteArray(emailAddress.substring(0, emailAddress.indexOf(64)));
        try {
            OutputStream cOut = this.digestCalculator.getOutputStream();
            cOut.write(enc);
            cOut.close();
        }
        catch (IOException e) {
            throw new DANEException("Unable to calculate digest string: " + e.getMessage(), e);
        }
        byte[] hash = this.digestCalculator.getDigest();
        String domainName = String.valueOf(Strings.fromByteArray(Hex.encode(hash))) + "._smimecert." + emailAddress.substring(emailAddress.indexOf(64) + 1);
        return new DANEEntrySelector(domainName);
    }
}

