/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cert.jcajce;

import cn.win_trust_erpc.bouncycastle.asn1.x500.X500Name;
import cn.win_trust_erpc.bouncycastle.asn1.x500.X500NameStyle;
import cn.win_trust_erpc.bouncycastle.jcajce.interfaces.BCX509Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class JcaX500NameUtil {
    public static X500Name getIssuer(X509Certificate certificate) {
        if (certificate instanceof BCX509Certificate) {
            return JcaX500NameUtil.notNull(((BCX509Certificate)((Object)certificate)).getIssuerX500Name());
        }
        return JcaX500NameUtil.getX500Name(certificate.getIssuerX500Principal());
    }

    public static X500Name getIssuer(X500NameStyle style, X509Certificate certificate) {
        if (certificate instanceof BCX509Certificate) {
            return X500Name.getInstance(style, JcaX500NameUtil.notNull(((BCX509Certificate)((Object)certificate)).getIssuerX500Name()));
        }
        return JcaX500NameUtil.getX500Name(style, certificate.getIssuerX500Principal());
    }

    public static X500Name getSubject(X509Certificate certificate) {
        if (certificate instanceof BCX509Certificate) {
            return JcaX500NameUtil.notNull(((BCX509Certificate)((Object)certificate)).getSubjectX500Name());
        }
        return JcaX500NameUtil.getX500Name(certificate.getSubjectX500Principal());
    }

    public static X500Name getSubject(X500NameStyle style, X509Certificate certificate) {
        if (certificate instanceof BCX509Certificate) {
            return X500Name.getInstance(style, JcaX500NameUtil.notNull(((BCX509Certificate)((Object)certificate)).getSubjectX500Name()));
        }
        return JcaX500NameUtil.getX500Name(style, certificate.getSubjectX500Principal());
    }

    public static X500Name getX500Name(X500Principal principal) {
        return X500Name.getInstance(JcaX500NameUtil.getEncoded(principal));
    }

    public static X500Name getX500Name(X500NameStyle style, X500Principal principal) {
        return X500Name.getInstance(style, JcaX500NameUtil.getEncoded(principal));
    }

    private static X500Name notNull(X500Name name) {
        if (name == null) {
            throw new IllegalStateException();
        }
        return name;
    }

    private static X500Principal notNull(X500Principal principal) {
        if (principal == null) {
            throw new IllegalStateException();
        }
        return principal;
    }

    private static byte[] getEncoded(X500Principal principal) {
        return JcaX500NameUtil.notNull(principal).getEncoded();
    }
}

