/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.BEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.DEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSet;
import cn.win_trust_erpc.bouncycastle.asn1.DLSet;
import cn.win_trust_erpc.bouncycastle.asn1.cms.AttributeTable;
import cn.win_trust_erpc.bouncycastle.asn1.cms.AuthEnvelopedData;
import cn.win_trust_erpc.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.cms.ContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.EncryptedContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.cms.CMSAuthEnvelopedData;
import cn.win_trust_erpc.bouncycastle.cms.CMSAuthEnvelopedGenerator;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.CMSTypedData;
import cn.win_trust_erpc.bouncycastle.cms.RecipientInfoGenerator;
import cn.win_trust_erpc.bouncycastle.operator.GenericKey;
import cn.win_trust_erpc.bouncycastle.operator.OutputAEADEncryptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;

public class CMSAuthEnvelopedDataGenerator
extends CMSAuthEnvelopedGenerator {
    private CMSAuthEnvelopedData doGenerate(CMSTypedData content, OutputAEADEncryptor contentEncryptor) throws CMSException {
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DERSet authenticatedAttrSet = null;
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            if (this.authAttrsGenerator != null) {
                AttributeTable attrTable = this.authAttrsGenerator.getAttributes(Collections.EMPTY_MAP);
                authenticatedAttrSet = new DERSet(attrTable.toASN1EncodableVector());
                contentEncryptor.getAADStream().write(authenticatedAttrSet.getEncoded("DER"));
            }
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("unable to process authenticated content: " + e.getMessage(), e);
        }
        byte[] encryptedContent = bOut.toByteArray();
        byte[] mac = contentEncryptor.getMAC();
        AlgorithmIdentifier encAlgId = contentEncryptor.getAlgorithmIdentifier();
        BEROctetString encContent = new BEROctetString(encryptedContent);
        GenericKey encKey = contentEncryptor.getKey();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add(recipient.generate(encKey));
        }
        EncryptedContentInfo eci = new EncryptedContentInfo(content.getContentType(), encAlgId, encContent);
        DLSet unprotectedAttrSet = null;
        if (this.unauthAttrsGenerator != null) {
            AttributeTable attrTable = this.unauthAttrsGenerator.getAttributes(Collections.EMPTY_MAP);
            unprotectedAttrSet = new DLSet(attrTable.toASN1EncodableVector());
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authEnvelopedData, new AuthEnvelopedData(this.originatorInfo, new DERSet(recipientInfos), eci, authenticatedAttrSet, new DEROctetString(mac), unprotectedAttrSet));
        return new CMSAuthEnvelopedData(contentInfo);
    }

    public CMSAuthEnvelopedData generate(CMSTypedData content, OutputAEADEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

