/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1OctetString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cn.win_trust_erpc.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import cn.win_trust_erpc.bouncycastle.asn1.cms.OriginatorPublicKey;
import cn.win_trust_erpc.bouncycastle.asn1.cms.RecipientEncryptedKey;
import cn.win_trust_erpc.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.cms.AuthAttributesProvider;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.CMSSecureReadable;
import cn.win_trust_erpc.bouncycastle.cms.KeyAgreeRecipient;
import cn.win_trust_erpc.bouncycastle.cms.KeyAgreeRecipientId;
import cn.win_trust_erpc.bouncycastle.cms.OriginatorId;
import cn.win_trust_erpc.bouncycastle.cms.Recipient;
import cn.win_trust_erpc.bouncycastle.cms.RecipientId;
import cn.win_trust_erpc.bouncycastle.cms.RecipientInformation;
import cn.win_trust_erpc.bouncycastle.cms.RecipientOperator;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.List;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString encryptedKey;

    static void readRecipientInfo(List infos, KeyAgreeRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ASN1Sequence s = info.getRecipientEncryptedKeys();
        int i = 0;
        while (i < s.size()) {
            KeyAgreeRecipientId rid;
            RecipientEncryptedKey id = RecipientEncryptedKey.getInstance(s.getObjectAt(i));
            KeyAgreeRecipientIdentifier karid = id.getIdentifier();
            IssuerAndSerialNumber iAndSN = karid.getIssuerAndSerialNumber();
            if (iAndSN != null) {
                rid = new KeyAgreeRecipientId(iAndSN.getName(), iAndSN.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier rKeyID = karid.getRKeyID();
                rid = new KeyAgreeRecipientId(rKeyID.getSubjectKeyIdentifier().getOctets());
            }
            infos.add(new KeyAgreeRecipientInformation(info, rid, id.getEncryptedKey(), messageAlgorithm, secureReadable, additionalData));
            ++i;
        }
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo info, RecipientId rid, ASN1OctetString encryptedKey, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        this.rid = rid;
        this.encryptedKey = encryptedKey;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.info.getOriginator();
    }

    public byte[] getUserKeyingMaterial() {
        ASN1OctetString ukm = this.info.getUserKeyingMaterial();
        if (ukm != null) {
            return Arrays.clone(ukm.getOctets());
        }
        return null;
    }

    private SubjectPublicKeyInfo getSenderPublicKeyInfo(AlgorithmIdentifier recKeyAlgId, OriginatorIdentifierOrKey originator) throws CMSException, IOException {
        OriginatorId origID;
        OriginatorPublicKey opk = originator.getOriginatorKey();
        if (opk != null) {
            return this.getPublicKeyInfoFromOriginatorPublicKey(recKeyAlgId, opk);
        }
        IssuerAndSerialNumber iAndSN = originator.getIssuerAndSerialNumber();
        if (iAndSN != null) {
            origID = new OriginatorId(iAndSN.getName(), iAndSN.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier ski = originator.getSubjectKeyIdentifier();
            origID = new OriginatorId(ski.getKeyIdentifier());
        }
        return this.getPublicKeyInfoFromOriginatorId(origID);
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorPublicKey(AlgorithmIdentifier recKeyAlgId, OriginatorPublicKey originatorPublicKey) {
        SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(recKeyAlgId, originatorPublicKey.getPublicKey().getBytes());
        return pubInfo;
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorId(OriginatorId origID) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        KeyAgreeRecipient agreeRecipient = (KeyAgreeRecipient)recipient;
        AlgorithmIdentifier recKeyAlgId = agreeRecipient.getPrivateKeyAlgorithmIdentifier();
        return ((KeyAgreeRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.getSenderPublicKeyInfo(recKeyAlgId, this.info.getOriginator()), this.info.getUserKeyingMaterial(), this.encryptedKey.getOctets());
    }
}

