/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms.bc;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1OctetString;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PBKDF2Params;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.PasswordRecipient;
import cn.win_trust_erpc.bouncycastle.cms.bc.EnvelopedDataHelper;
import cn.win_trust_erpc.bouncycastle.crypto.InvalidCipherTextException;
import cn.win_trust_erpc.bouncycastle.crypto.PBEParametersGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.Wrapper;
import cn.win_trust_erpc.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithIV;

public abstract class BcPasswordRecipient
implements PasswordRecipient {
    private final char[] password;
    private int schemeID = 1;

    BcPasswordRecipient(char[] password) {
        this.password = password;
    }

    public BcPasswordRecipient setPasswordConversionScheme(int schemeID) {
        this.schemeID = schemeID;
        return this;
    }

    protected KeyParameter extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        Wrapper keyEncryptionCipher = EnvelopedDataHelper.createRFC3211Wrapper(keyEncryptionAlgorithm.getAlgorithm());
        keyEncryptionCipher.init(false, new ParametersWithIV(new KeyParameter(derivedKey), ASN1OctetString.getInstance(keyEncryptionAlgorithm.getParameters()).getOctets()));
        try {
            return new KeyParameter(keyEncryptionCipher.unwrap(encryptedContentEncryptionKey, 0, encryptedContentEncryptionKey.length));
        }
        catch (InvalidCipherTextException e) {
            throw new CMSException("unable to unwrap key: " + e.getMessage(), e);
        }
    }

    @Override
    public byte[] calculateDerivedKey(int schemeID, AlgorithmIdentifier derivationAlgorithm, int keySize) throws CMSException {
        PBKDF2Params params = PBKDF2Params.getInstance(derivationAlgorithm.getParameters());
        byte[] encodedPassword = schemeID == 0 ? PBEParametersGenerator.PKCS5PasswordToBytes(this.password) : PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.password);
        try {
            PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator(EnvelopedDataHelper.getPRF(params.getPrf()));
            gen.init(encodedPassword, params.getSalt(), params.getIterationCount().intValue());
            return ((KeyParameter)gen.generateDerivedParameters(keySize)).getKey();
        }
        catch (Exception e) {
            throw new CMSException("exception creating derived key: " + e.getMessage(), e);
        }
    }

    @Override
    public int getPasswordConversionScheme() {
        return this.schemeID;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }
}

