/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.agreement;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.crypto.agreement.DHBasicAgreement;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHUPrivateParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHUPublicParameters;
import cn.win_trust_erpc.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DHUnifiedAgreement {
    private DHUPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (DHUPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        DHUPublicParameters pubParams = (DHUPublicParameters)pubKey;
        DHBasicAgreement sAgree = new DHBasicAgreement();
        DHBasicAgreement eAgree = new DHBasicAgreement();
        sAgree.init(this.privParams.getStaticPrivateKey());
        BigInteger sComp = sAgree.calculateAgreement(pubParams.getStaticPublicKey());
        eAgree.init(this.privParams.getEphemeralPrivateKey());
        BigInteger eComp = eAgree.calculateAgreement(pubParams.getEphemeralPublicKey());
        int fieldSize = this.getFieldSize();
        byte[] result = new byte[fieldSize * 2];
        BigIntegers.asUnsignedByteArray(eComp, result, 0, fieldSize);
        BigIntegers.asUnsignedByteArray(sComp, result, fieldSize, fieldSize);
        return result;
    }
}

