/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.digests;

import cn.win_trust_erpc.bouncycastle.crypto.ExtendedDigest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SkeinEngine;
import cn.win_trust_erpc.bouncycastle.crypto.params.SkeinParameters;
import cn.win_trust_erpc.bouncycastle.util.Memoable;

public class SkeinDigest
implements ExtendedDigest,
Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine engine;

    public SkeinDigest(int stateSizeBits, int digestSizeBits) {
        this.engine = new SkeinEngine(stateSizeBits, digestSizeBits);
        this.init(null);
    }

    public SkeinDigest(SkeinDigest digest) {
        this.engine = new SkeinEngine(digest.engine);
    }

    @Override
    public void reset(Memoable other) {
        SkeinDigest d = (SkeinDigest)other;
        this.engine.reset(d.engine);
    }

    @Override
    public Memoable copy() {
        return new SkeinDigest(this);
    }

    @Override
    public String getAlgorithmName() {
        return "Skein-" + this.engine.getBlockSize() * 8 + "-" + this.engine.getOutputSize() * 8;
    }

    @Override
    public int getDigestSize() {
        return this.engine.getOutputSize();
    }

    @Override
    public int getByteLength() {
        return this.engine.getBlockSize();
    }

    public void init(SkeinParameters params) {
        this.engine.init(params);
    }

    @Override
    public void reset() {
        this.engine.reset();
    }

    @Override
    public void update(byte in) {
        this.engine.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.engine.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.engine.doFinal(out, outOff);
    }
}

