/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.parsers;

import cn.win_trust_erpc.bouncycastle.crypto.KeyParser;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DHIESPublicKeyParser
implements KeyParser {
    private DHParameters dhParams;

    public DHIESPublicKeyParser(DHParameters dhParams) {
        this.dhParams = dhParams;
    }

    @Override
    public AsymmetricKeyParameter readKey(InputStream stream) throws IOException {
        byte[] V = new byte[(this.dhParams.getP().bitLength() + 7) / 8];
        Streams.readFully(stream, V, 0, V.length);
        return new DHPublicKeyParameters(new BigInteger(1, V), this.dhParams);
    }
}

