/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.digest;

import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.digests.MD4Digest;
import cn.win_trust_erpc.bouncycastle.crypto.macs.HMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class MD4 {
    private MD4() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new MD4Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new MD4Digest((MD4Digest)this.digest);
            return d;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new MD4Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACMD4", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = MD4.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.MD4", String.valueOf(PREFIX) + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + PKCSObjectIdentifiers.md4, "MD4");
            this.addHMACAlgorithm(provider, "MD4", String.valueOf(PREFIX) + "$HashMac", String.valueOf(PREFIX) + "$KeyGenerator");
        }
    }
}

