/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric;

import cn.win_trust_erpc.bouncycastle.crypto.BufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.engines.GOST3412_2015Engine;
import cn.win_trust_erpc.bouncycastle.crypto.macs.CMac;
import cn.win_trust_erpc.bouncycastle.crypto.modes.G3413CBCBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.modes.G3413CFBBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.modes.G3413CTRBlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.modes.G3413OFBBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public class GOST3412_2015 {

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new G3413CBCBlockCipher(new GOST3412_2015Engine()), false, 128);
        }
    }

    public static class CTR
    extends BaseBlockCipher {
        public CTR() {
            super(new BufferedBlockCipher(new G3413CTRBlockCipher(new GOST3412_2015Engine())), true, 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new GOST3412_2015Engine());
        }
    }

    public static class GCFB
    extends BaseBlockCipher {
        public GCFB() {
            super(new BufferedBlockCipher(new G3413CFBBlockCipher(new GOST3412_2015Engine())), false, 128);
        }
    }

    public static class GCFB8
    extends BaseBlockCipher {
        public GCFB8() {
            super(new BufferedBlockCipher(new G3413CFBBlockCipher(new GOST3412_2015Engine(), 8)), false, 128);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int keySize) {
            super("GOST3412-2015", keySize, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new CMac(new GOST3412_2015Engine()));
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = GOST3412_2015.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.GOST3412-2015", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher.GOST3412-2015/CFB", String.valueOf(PREFIX) + "$GCFB");
            provider.addAlgorithm("Cipher.GOST3412-2015/CFB8", String.valueOf(PREFIX) + "$GCFB8");
            provider.addAlgorithm("Cipher.GOST3412-2015/OFB", String.valueOf(PREFIX) + "$OFB");
            provider.addAlgorithm("Cipher.GOST3412-2015/CBC", String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher.GOST3412-2015/CTR", String.valueOf(PREFIX) + "$CTR");
            provider.addAlgorithm("KeyGenerator.GOST3412-2015", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("Mac.GOST3412MAC", String.valueOf(PREFIX) + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.GOST3412-2015", "GOST3412MAC");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new G3413OFBBlockCipher(new GOST3412_2015Engine())), false, 128);
        }
    }
}

