/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric;

import cn.win_trust_erpc.bouncycastle.asn1.misc.IDEACBCPar;
import cn.win_trust_erpc.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.CryptoServicesRegistrar;
import cn.win_trust_erpc.bouncycastle.crypto.engines.IDEAEngine;
import cn.win_trust_erpc.bouncycastle.crypto.macs.CBCBlockCipherMac;
import cn.win_trust_erpc.bouncycastle.crypto.macs.CFBBlockCipherMac;
import cn.win_trust_erpc.bouncycastle.crypto.modes.CBCBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public final class IDEA {
    private IDEA() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for IDEA parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[8];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance("IDEA");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        private byte[] iv;

        @Override
        protected byte[] engineGetEncoded() throws IOException {
            return this.engineGetEncoded("ASN.1");
        }

        @Override
        protected byte[] engineGetEncoded(String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                return new IDEACBCPar(this.engineGetEncoded("RAW")).getEncoded();
            }
            if (format.equals("RAW")) {
                byte[] tmp = new byte[this.iv.length];
                System.arraycopy(this.iv, 0, tmp, 0, this.iv.length);
                return tmp;
            }
            return null;
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if (paramSpec == IvParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to IV parameters object.");
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)paramSpec).getIV();
        }

        @Override
        protected void engineInit(byte[] params) throws IOException {
            this.iv = new byte[params.length];
            System.arraycopy(params, 0, this.iv, 0, this.iv.length);
        }

        @Override
        protected void engineInit(byte[] params, String format) throws IOException {
            if (format.equals("RAW")) {
                this.engineInit(params);
                return;
            }
            if (format.equals("ASN.1")) {
                IDEACBCPar oct = IDEACBCPar.getInstance(params);
                this.engineInit(oct.getIV());
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        @Override
        protected String engineToString() {
            return "IDEA Parameters";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new IDEAEngine()), 64);
        }
    }

    public static class CFB8Mac
    extends BaseMac {
        public CFB8Mac() {
            super(new CFBBlockCipherMac(new IDEAEngine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new IDEAEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("IDEA", 128, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new CBCBlockCipherMac(new IDEAEngine()));
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = IDEA.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameterGenerator.IDEA", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("AlgorithmParameterGenerator.1.3.6.1.4.1.188.7.1.1.2", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("AlgorithmParameters.IDEA", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("AlgorithmParameters.1.3.6.1.4.1.188.7.1.1.2", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDIDEA", "PKCS12PBE");
            provider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDIDEA-CBC", "PKCS12PBE");
            provider.addAlgorithm("Cipher.IDEA", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher.PBEWITHSHAANDIDEA-CBC", String.valueOf(PREFIX) + "$PBEWithSHAAndIDEA");
            provider.addAlgorithm("KeyGenerator.IDEA", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("KeyGenerator", MiscObjectIdentifiers.as_sys_sec_alg_ideaCBC, String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("SecretKeyFactory.PBEWITHSHAANDIDEA-CBC", String.valueOf(PREFIX) + "$PBEWithSHAAndIDEAKeyGen");
            provider.addAlgorithm("Mac.IDEAMAC", String.valueOf(PREFIX) + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.IDEA", "IDEAMAC");
            provider.addAlgorithm("Mac.IDEAMAC/CFB8", String.valueOf(PREFIX) + "$CFB8Mac");
            provider.addAlgorithm("Alg.Alias.Mac.IDEA/CFB8", "IDEAMAC/CFB8");
        }
    }

    public static class PBEWithSHAAndIDEA
    extends BaseBlockCipher {
        public PBEWithSHAAndIDEA() {
            super(new CBCBlockCipher(new IDEAEngine()));
        }
    }

    public static class PBEWithSHAAndIDEAKeyGen
    extends PBESecretKeyFactory {
        public PBEWithSHAAndIDEAKeyGen() {
            super("PBEwithSHAandIDEA-CBC", null, true, 2, 1, 128, 64);
        }
    }
}

