/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric;

import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.engines.VMPCEngine;
import cn.win_trust_erpc.bouncycastle.crypto.macs.VMPCMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class VMPC {
    private VMPC() {
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new VMPCEngine(), 16);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("VMPC", 128, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new VMPCMac());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = VMPC.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.VMPC", String.valueOf(PREFIX) + "$Base");
            provider.addAlgorithm("KeyGenerator.VMPC", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("Mac.VMPCMAC", String.valueOf(PREFIX) + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.VMPC", "VMPCMAC");
            provider.addAlgorithm("Alg.Alias.Mac.VMPC-MAC", "VMPCMAC");
        }
    }
}

