/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jce.provider;

import cn.win_trust_erpc.bouncycastle.jcajce.PKIXCertRevocationChecker;
import cn.win_trust_erpc.bouncycastle.jcajce.PKIXCertRevocationCheckerParameters;
import cn.win_trust_erpc.bouncycastle.jcajce.util.JcaJceHelper;
import cn.win_trust_erpc.bouncycastle.jce.provider.AnnotatedException;
import cn.win_trust_erpc.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;

class ProvCrlRevocationChecker
implements PKIXCertRevocationChecker {
    private final JcaJceHelper helper;
    private PKIXCertRevocationCheckerParameters params;
    private Date currentDate = null;

    public ProvCrlRevocationChecker(JcaJceHelper helper) {
        this.helper = helper;
    }

    @Override
    public void setParameter(String name, Object value) {
    }

    @Override
    public void initialize(PKIXCertRevocationCheckerParameters params) {
        this.params = params;
        this.currentDate = new Date();
    }

    public void init(boolean forForward) throws CertPathValidatorException {
        if (forForward) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.params = null;
        this.currentDate = new Date();
    }

    @Override
    public void check(Certificate certificate) throws CertPathValidatorException {
        try {
            RFC3280CertPathUtilities.checkCRLs(this.params, this.params.getParamsPKIX(), this.currentDate, this.params.getValidDate(), (X509Certificate)certificate, this.params.getSigningCert(), this.params.getWorkingPublicKey(), this.params.getCertPath().getCertificates(), this.helper);
        }
        catch (AnnotatedException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new CertPathValidatorException(e.getMessage(), cause, this.params.getCertPath(), this.params.getIndex());
        }
    }
}

