/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse;

import cn.win_trust_erpc.bouncycastle.jsse.BCSNIMatcher;
import cn.win_trust_erpc.bouncycastle.jsse.BCSNIServerName;
import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class BCSSLParameters {
    private String[] applicationProtocols = TlsUtils.EMPTY_STRINGS;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private String endpointIdentificationAlgorithm;
    private BCAlgorithmConstraints algorithmConstraints;
    private List<BCSNIServerName> serverNames;
    private List<BCSNIMatcher> sniMatchers;
    private boolean useCipherSuitesOrder;

    private static <T> List<T> copyList(Collection<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public BCSSLParameters() {
    }

    public BCSSLParameters(String[] cipherSuites) {
        this.setCipherSuites(cipherSuites);
    }

    public BCSSLParameters(String[] cipherSuites, String[] protocols) {
        this.setCipherSuites(cipherSuites);
        this.setProtocols(protocols);
    }

    public String[] getApplicationProtocols() {
        return TlsUtils.clone(this.applicationProtocols);
    }

    public void setApplicationProtocols(String[] applicationProtocols) {
        String[] check;
        if (applicationProtocols == null) {
            throw new NullPointerException("'applicationProtocols' cannot be null");
        }
        String[] stringArray = check = TlsUtils.clone(applicationProtocols);
        int n = check.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (TlsUtils.isNullOrEmpty(entry)) {
                throw new IllegalArgumentException("'applicationProtocols' entries cannot be null or empty strings");
            }
            ++n2;
        }
        this.applicationProtocols = check;
    }

    public String[] getCipherSuites() {
        return TlsUtils.clone(this.cipherSuites);
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = TlsUtils.clone(cipherSuites);
    }

    public String[] getProtocols() {
        return TlsUtils.clone(this.protocols);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = TlsUtils.clone(protocols);
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = false;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = false;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    public BCAlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(BCAlgorithmConstraints algorithmConstraints) {
        this.algorithmConstraints = algorithmConstraints;
    }

    public void setServerNames(List<BCSNIServerName> serverNames) {
        if (serverNames == null) {
            this.serverNames = null;
        } else {
            List<BCSNIServerName> copy = BCSSLParameters.copyList(serverNames);
            HashSet<Integer> types = new HashSet<Integer>();
            for (BCSNIServerName serverName : copy) {
                int type = serverName.getType();
                if (types.add(type)) continue;
                throw new IllegalArgumentException("Found duplicate SNI server name entry of type " + type);
            }
            this.serverNames = copy;
        }
    }

    public List<BCSNIServerName> getServerNames() {
        return BCSSLParameters.copyList(this.serverNames);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> sniMatchers) {
        if (sniMatchers == null) {
            this.sniMatchers = null;
        } else {
            List<BCSNIMatcher> copy = BCSSLParameters.copyList(sniMatchers);
            HashSet<Integer> types = new HashSet<Integer>();
            for (BCSNIMatcher sniMatcher : copy) {
                int type = sniMatcher.getType();
                if (types.add(type)) continue;
                throw new IllegalArgumentException("Found duplicate SNI matcher entry of type " + type);
            }
            this.sniMatchers = copy;
        }
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return BCSSLParameters.copyList(this.sniMatchers);
    }

    public void setUseCipherSuitesOrder(boolean useCipherSuitesOrder) {
        this.useCipherSuitesOrder = useCipherSuitesOrder;
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }
}

