/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.provider.AlgorithmDecomposer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

class JcaAlgorithmDecomposer
implements AlgorithmDecomposer {
    private static final Pattern PATTERN = Pattern.compile("with|and|(?<!padd)in", 2);
    static final JcaAlgorithmDecomposer INSTANCE_JCA = new JcaAlgorithmDecomposer();

    JcaAlgorithmDecomposer() {
    }

    @Override
    public Set<String> decompose(String algorithm) {
        if (algorithm.indexOf(47) < 0) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        String[] stringArray = algorithm.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String section = stringArray[n2];
            if (section.length() > 0) {
                String[] stringArray2 = PATTERN.split(section);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String part = stringArray2[n4];
                    if (part.length() > 0) {
                        result.add(part);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA1", "SHA-1");
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA224", "SHA-224");
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA256", "SHA-256");
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA384", "SHA-384");
        JcaAlgorithmDecomposer.ensureBothIfEither(result, "SHA512", "SHA-512");
        return result;
    }

    private static void ensureBothIfEither(Set<String> elements, String a, String b) {
        boolean hasB;
        boolean hasA = elements.contains(a);
        if (hasA ^ (hasB = elements.contains(b))) {
            elements.add(hasA ? b : a);
        }
    }
}

