/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseSecurityParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseSessionParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionContext;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.SessionParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsSession;

class ProvSSLSessionResumed
extends ProvSSLSessionHandshake {
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;
    protected final JsseSessionParameters jsseSessionParameters;

    ProvSSLSessionResumed(ProvSSLSessionContext sslSessionContext, String peerHost, int peerPort, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters, TlsSession tlsSession, JsseSessionParameters jsseSessionParameters) {
        super(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters);
        this.tlsSession = tlsSession;
        this.sessionParameters = tlsSession.exportSessionParameters();
        this.jsseSessionParameters = jsseSessionParameters;
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.sessionParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.tlsSession.getSessionID();
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return this.jsseSessionParameters;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.sessionParameters.getLocalCertificate();
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.sessionParameters.getPeerCertificate();
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.sessionParameters.getNegotiatedVersion();
    }

    @Override
    protected void invalidateTLS() {
        this.tlsSession.invalidate();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.tlsSession.isResumable();
    }
}

