/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCApplicationProtocolSelector;
import cn.win_trust_erpc.bouncycastle.jsse.BCExtendedSSLSession;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLConnection;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.BCX509Key;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ContextData;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseSecurityParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLConnection;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSession;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionContext;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSocketBase;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsClient;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsClientProtocol;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsManager;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsPeer;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsServer;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvTlsServerProtocol;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SSLParametersUtil;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

class ProvSSLSocketDirect
extends ProvSSLSocketBase
implements ProvTlsManager {
    private static final Logger LOG = Logger.getLogger(ProvSSLSocketDirect.class.getName());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected String peerHost = null;
    protected String peerHostSNI = null;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected ProvSSLConnection connection = null;
    protected ProvSSLSessionHandshake handshakeSession = null;

    ProvSSLSocketDirect(ContextData contextData, boolean enableSessionCreation, boolean useClientMode, ProvSSLParameters sslParameters) {
        this.contextData = contextData;
        this.enableSessionCreation = enableSessionCreation;
        this.useClientMode = useClientMode;
        this.sslParameters = sslParameters;
    }

    protected ProvSSLSocketDirect(ContextData contextData) {
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
    }

    protected ProvSSLSocketDirect(ContextData contextData, InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
        this.implBind(clientAddress, clientPort);
        this.implConnect(address, port);
    }

    protected ProvSSLSocketDirect(ContextData contextData, InetAddress address, int port) throws IOException {
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
        this.implConnect(address, port);
    }

    protected ProvSSLSocketDirect(ContextData contextData, String host, int port, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
        this.peerHost = host;
        this.implBind(clientAddress, clientPort);
        this.implConnect(host, port);
    }

    protected ProvSSLSocketDirect(ContextData contextData, String host, int port) throws IOException, UnknownHostException {
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
        this.peerHost = host;
        this.implConnect(host, port);
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkClientTrusted((X509Certificate[])chain.clone(), authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws IOException {
        try {
            this.contextData.getX509TrustManager().checkServerTrusted((X509Certificate[])chain.clone(), authType, this);
        }
        catch (CertificateException e) {
            throw new TlsFatalAlert(46, (Throwable)e);
        }
    }

    @Override
    public BCX509Key chooseClientKey(String[] keyTypes, Principal[] issuers) {
        return this.getContextData().getX509KeyManager().chooseClientKeyBC(keyTypes, JsseUtils.clone(issuers), this);
    }

    @Override
    public BCX509Key chooseServerKey(String[] keyTypes, Principal[] issuers) {
        return this.getContextData().getX509KeyManager().chooseServerKeyBC(keyTypes, JsseUtils.clone(issuers), this);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new SocketException("Only InetSocketAddress is supported.");
        }
        super.connect(endpoint, timeout);
        this.notifyConnected();
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.close();
            }
            catch (IOException e1) {
                try {
                    super.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                super.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return this.connection == null ? null : this.connection.getApplicationProtocol();
    }

    @Override
    public synchronized BCApplicationProtocolSelector<SSLSocket> getBCHandshakeApplicationProtocolSelector() {
        return this.sslParameters.getSocketAPSelector();
    }

    @Override
    public synchronized BCExtendedSSLSession getBCHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public BCExtendedSSLSession getBCSession() {
        return this.getSessionImpl();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Failed to establish connection", e);
        }
        return this.connection;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return this.handshakeSession == null ? null : this.handshakeSession.getApplicationProtocol();
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession == null ? null : this.handshakeSession.getExportSSLSession();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public SSLSession getSession() {
        return this.getSessionImpl().getExportSSLSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.contextData.getContext().getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.contextData.getContext().getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized void setBCHandshakeApplicationProtocolSelector(BCApplicationProtocolSelector<SSLSocket> selector) {
        this.sslParameters.setSocketAPSelector(selector);
    }

    @Override
    public synchronized void setBCSessionToResume(BCExtendedSSLSession session) {
        if (session == null) {
            throw new NullPointerException("'session' cannot be null");
        }
        if (!(session instanceof ProvSSLSession)) {
            throw new IllegalArgumentException("Session-to-resume must be a session returned from 'getBCSession'");
        }
        if (this.protocol != null) {
            throw new IllegalArgumentException("Session-to-resume cannot be set after the handshake has begun");
        }
        this.sslParameters.setSessionToResume((ProvSSLSession)session);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setHost(String host) {
        this.peerHost = host;
        this.peerHostSNI = host;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean useClientMode) {
        if (this.protocol != null) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        if (this.useClientMode != useClientMode) {
            this.contextData.getContext().updateDefaultSSLParameters(this.sslParameters, useClientMode);
            this.useClientMode = useClientMode;
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("shutdownInput() not supported in TLS");
    }

    @Override
    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("shutdownOutput() not supported in TLS");
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean resumable) throws IOException {
        if (this.protocol == null) {
            InputStream input = super.getInputStream();
            OutputStream output = super.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol clientProtocol = new ProvTlsClientProtocol(input, output, this.socketCloser);
                clientProtocol.setResumableHandshake(resumable);
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters);
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                ProvTlsServerProtocol serverProtocol = new ProvTlsServerProtocol(input, output, this.socketCloser);
                serverProtocol.setResumableHandshake(resumable);
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters);
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(resumable);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    @Override
    public synchronized String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public synchronized String getPeerHostSNI() {
        return this.peerHostSNI;
    }

    @Override
    public int getPeerPort() {
        return this.getPort();
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        if (this.handshakeSession != null) {
            if (!this.handshakeSession.isValid()) {
                connection.getSession().invalidate();
            }
            this.handshakeSession.getJsseSecurityParameters().clear();
        }
        this.handshakeSession = null;
        this.connection = connection;
        this.notifyHandshakeCompletedListeners(connection.getSession().exportSSLSession);
    }

    @Override
    public synchronized void notifyHandshakeSession(ProvSSLSessionContext sslSessionContext, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters, ProvSSLSession resumedSession) {
        String peerHost = this.getPeerHost();
        int peerPort = this.getPeerPort();
        this.handshakeSession = resumedSession != null ? new ProvSSLSessionResumed(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters, resumedSession.getTlsSession(), resumedSession.getJsseSessionParameters()) : new ProvSSLSessionHandshake(sslSessionContext, peerHost, peerPort, securityParameters, jsseSecurityParameters);
    }

    @Override
    public synchronized String selectApplicationProtocol(List<String> protocols) {
        return this.sslParameters.getSocketAPSelector().select(this, protocols);
    }

    synchronized ProvSSLSession getSessionImpl() {
        this.getConnection();
        return this.connection == null ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
    }

    synchronized void handshakeIfNecessary(boolean resumable) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(resumable);
        }
    }

    synchronized void notifyConnected() {
        if (JsseUtils.isNameSpecified(this.peerHost)) {
            this.peerHostSNI = this.peerHost;
            return;
        }
        InetAddress peerAddress = this.getInetAddress();
        if (peerAddress == null) {
            return;
        }
        if (this.useClientMode && provAssumeOriginalHostName) {
            String originalHostName;
            this.peerHost = originalHostName = peerAddress.getHostName();
            this.peerHostSNI = originalHostName;
            return;
        }
        this.peerHost = this.useClientMode && provJdkTlsTrustNameService ? peerAddress.getHostName() : peerAddress.getHostAddress();
        this.peerHostSNI = null;
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[1];
            int ret = this.read(buf, 0, 1);
            return ret <= 0 ? -1 : buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            return ProvSSLSocketDirect.this.protocol.readApplicationData(b, off, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                return ProvSSLSocketDirect.this.protocol == null ? 0 : ProvSSLSocketDirect.this.protocol.applicationDataAvailable();
            }
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketDirect.this.handshakeIfNecessary(true);
                ProvSSLSocketDirect.this.protocol.writeApplicationData(b, off, len);
            }
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }
    }
}

