/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCExtendedSSLSession;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLEngine;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ContextData;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLEngine;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ReflectionUtil;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SSLParametersUtil;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SSLSessionUtil;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

abstract class SSLEngineUtil {
    private static final Method getHandshakeSession;
    private static final Method getSSLParameters;

    static {
        Method[] methods = ReflectionUtil.getMethods("javax.net.ssl.SSLEngine");
        getHandshakeSession = ReflectionUtil.findMethod(methods, "getHandshakeSession");
        getSSLParameters = ReflectionUtil.findMethod(methods, "getSSLParameters");
    }

    SSLEngineUtil() {
    }

    static SSLEngine create(ContextData contextData) {
        return new ProvSSLEngine(contextData);
    }

    static SSLEngine create(ContextData contextData, String host, int port) {
        return new ProvSSLEngine(contextData, host, port);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLEngine sslEngine) {
        SSLSession sslSession;
        if (sslEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sslEngine)).getBCHandshakeSession();
        }
        if (sslEngine != null && getHandshakeSession != null && (sslSession = (SSLSession)ReflectionUtil.invokeGetter(sslEngine, getHandshakeSession)) != null) {
            return SSLSessionUtil.importSSLSession(sslSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLEngine sslEngine) {
        if (sslEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sslEngine)).getParameters();
        }
        if (sslEngine == null || getSSLParameters == null) {
            return null;
        }
        SSLParameters sslParameters = (SSLParameters)ReflectionUtil.invokeGetter(sslEngine, getSSLParameters);
        if (sslParameters == null) {
            throw new RuntimeException("SSLEngine.getSSLParameters returned null");
        }
        return SSLParametersUtil.importSSLParameters(sslParameters);
    }
}

