/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pkcs;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Boolean;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1OctetString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Set;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.Attribute;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.CertificationRequest;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.x500.X500Name;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Extensions;
import cn.win_trust_erpc.bouncycastle.asn1.x509.ExtensionsGenerator;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.operator.ContentVerifier;
import cn.win_trust_erpc.bouncycastle.operator.ContentVerifierProvider;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCSException;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCSIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;

public class PKCS10CertificationRequest {
    private static Attribute[] EMPTY_ARRAY = new Attribute[0];
    private CertificationRequest certificationRequest;

    private static CertificationRequest parseBytes(byte[] encoding) throws IOException {
        try {
            CertificationRequest rv = CertificationRequest.getInstance(ASN1Primitive.fromByteArray(encoding));
            if (rv == null) {
                throw new PKCSIOException("empty data passed to constructor");
            }
            return rv;
        }
        catch (ClassCastException e) {
            throw new PKCSIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new PKCSIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public PKCS10CertificationRequest(CertificationRequest certificationRequest) {
        if (certificationRequest == null) {
            throw new NullPointerException("certificationRequest cannot be null");
        }
        this.certificationRequest = certificationRequest;
    }

    public PKCS10CertificationRequest(byte[] encoded) throws IOException {
        this(PKCS10CertificationRequest.parseBytes(encoded));
    }

    public CertificationRequest toASN1Structure() {
        return this.certificationRequest;
    }

    public X500Name getSubject() {
        return X500Name.getInstance(this.certificationRequest.getCertificationRequestInfo().getSubject());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.certificationRequest.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.certificationRequest.getSignature().getOctets();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.certificationRequest.getCertificationRequestInfo().getSubjectPublicKeyInfo();
    }

    public Attribute[] getAttributes() {
        ASN1Set attrSet = this.certificationRequest.getCertificationRequestInfo().getAttributes();
        if (attrSet == null) {
            return EMPTY_ARRAY;
        }
        Attribute[] attrs = new Attribute[attrSet.size()];
        int i = 0;
        while (i != attrSet.size()) {
            attrs[i] = Attribute.getInstance(attrSet.getObjectAt(i));
            ++i;
        }
        return attrs;
    }

    public Attribute[] getAttributes(ASN1ObjectIdentifier type) {
        ASN1Set attrSet = this.certificationRequest.getCertificationRequestInfo().getAttributes();
        if (attrSet == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        int i = 0;
        while (i != attrSet.size()) {
            Attribute attr = Attribute.getInstance(attrSet.getObjectAt(i));
            if (attr.getAttrType().equals(type)) {
                list.add(attr);
            }
            ++i;
        }
        if (list.size() == 0) {
            return EMPTY_ARRAY;
        }
        return list.toArray(new Attribute[list.size()]);
    }

    public byte[] getEncoded() throws IOException {
        return this.certificationRequest.getEncoded();
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws PKCSException {
        ContentVerifier verifier;
        CertificationRequestInfo requestInfo = this.certificationRequest.getCertificationRequestInfo();
        try {
            verifier = verifierProvider.get(this.certificationRequest.getSignatureAlgorithm());
            OutputStream sOut = verifier.getOutputStream();
            sOut.write(requestInfo.getEncoded("DER"));
            sOut.close();
        }
        catch (Exception e) {
            throw new PKCSException("unable to process signature: " + e.getMessage(), e);
        }
        return verifier.verify(this.getSignature());
    }

    public Extensions getRequestedExtensions() {
        Attribute[] attributes = this.getAttributes();
        int i = 0;
        while (i != attributes.length) {
            Attribute encodable = attributes[i];
            if (encodable.getAttrType() == PKCSObjectIdentifiers.pkcs_9_at_extensionRequest) {
                ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
                ASN1Sequence extensionSequence = ASN1Sequence.getInstance(encodable.getAttrValues().getObjectAt(0));
                Enumeration en = extensionSequence.getObjects();
                while (en.hasMoreElements()) {
                    boolean critical;
                    ASN1Sequence itemSeq = ASN1Sequence.getInstance(en.nextElement());
                    boolean bl = critical = itemSeq.size() == 3 && ASN1Boolean.getInstance(itemSeq.getObjectAt(1)).isTrue();
                    if (itemSeq.size() == 2) {
                        extensionsGenerator.addExtension(ASN1ObjectIdentifier.getInstance(itemSeq.getObjectAt(0)), false, ASN1OctetString.getInstance(itemSeq.getObjectAt(1)).getOctets());
                        continue;
                    }
                    if (itemSeq.size() == 3) {
                        extensionsGenerator.addExtension(ASN1ObjectIdentifier.getInstance(itemSeq.getObjectAt(0)), critical, ASN1OctetString.getInstance(itemSeq.getObjectAt(2)).getOctets());
                        continue;
                    }
                    throw new IllegalArgumentException("incorrect sequence size of Extension get " + itemSeq.size() + " expected 2 or three");
                }
                return extensionsGenerator.generate();
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PKCS10CertificationRequest)) {
            return false;
        }
        PKCS10CertificationRequest other = (PKCS10CertificationRequest)o;
        return this.toASN1Structure().equals(other.toASN1Structure());
    }

    public int hashCode() {
        return this.toASN1Structure().hashCode();
    }
}

