/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pkcs;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.DEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.DLSequence;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.ContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.MacData;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.Pfx;
import cn.win_trust_erpc.bouncycastle.cms.CMSEncryptedDataGenerator;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.CMSProcessableByteArray;
import cn.win_trust_erpc.bouncycastle.operator.OutputEncryptor;
import cn.win_trust_erpc.bouncycastle.pkcs.MacDataGenerator;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCS12PfxPdu;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCS12SafeBag;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCSException;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCSIOException;
import java.io.IOException;

public class PKCS12PfxPduBuilder {
    private ASN1EncodableVector dataVector = new ASN1EncodableVector();

    public PKCS12PfxPduBuilder addData(PKCS12SafeBag data) throws IOException {
        this.dataVector.add(new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(new DLSequence(data.toASN1Structure()).getEncoded())));
        return this;
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, PKCS12SafeBag data) throws IOException {
        return this.addEncryptedData(dataEncryptor, new DERSequence(data.toASN1Structure()));
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, PKCS12SafeBag[] data) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i != data.length) {
            v.add(data[i].toASN1Structure());
            ++i;
        }
        return this.addEncryptedData(dataEncryptor, new DLSequence(v));
    }

    private PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor dataEncryptor, ASN1Sequence data) throws IOException {
        CMSEncryptedDataGenerator envGen = new CMSEncryptedDataGenerator();
        try {
            this.dataVector.add(envGen.generate(new CMSProcessableByteArray(data.getEncoded()), dataEncryptor).toASN1Structure());
        }
        catch (CMSException e) {
            throw new PKCSIOException(e.getMessage(), e.getCause());
        }
        return this;
    }

    public PKCS12PfxPdu build(PKCS12MacCalculatorBuilder macCalcBuilder, char[] password) throws PKCSException {
        byte[] encAuth;
        AuthenticatedSafe auth = AuthenticatedSafe.getInstance(new DLSequence(this.dataVector));
        try {
            encAuth = auth.getEncoded();
        }
        catch (IOException e) {
            throw new PKCSException("unable to encode AuthenticatedSafe: " + e.getMessage(), e);
        }
        ContentInfo mainInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(encAuth));
        MacData mData = null;
        if (macCalcBuilder != null) {
            MacDataGenerator mdGen = new MacDataGenerator(macCalcBuilder);
            mData = mdGen.build(password, encAuth);
        }
        Pfx pfx = new Pfx(mainInfo, mData);
        return new PKCS12PfxPdu(pfx);
    }
}

