/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pkcs;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1OctetString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.ContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.SafeBag;
import cn.win_trust_erpc.bouncycastle.cms.CMSEncryptedData;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.operator.InputDecryptorProvider;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCS12SafeBag;
import cn.win_trust_erpc.bouncycastle.pkcs.PKCSException;

public class PKCS12SafeBagFactory {
    private ASN1Sequence safeBagSeq;

    public PKCS12SafeBagFactory(ContentInfo info) {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
        }
        this.safeBagSeq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(info.getContent()).getOctets());
    }

    public PKCS12SafeBagFactory(ContentInfo info, InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            CMSEncryptedData encData = new CMSEncryptedData(cn.win_trust_erpc.bouncycastle.asn1.cms.ContentInfo.getInstance(info));
            try {
                this.safeBagSeq = ASN1Sequence.getInstance(encData.getContent(inputDecryptorProvider));
            }
            catch (CMSException e) {
                throw new PKCSException("unable to extract data: " + e.getMessage(), e);
            }
            return;
        }
        throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
    }

    public PKCS12SafeBag[] getSafeBags() {
        PKCS12SafeBag[] safeBags = new PKCS12SafeBag[this.safeBagSeq.size()];
        int i = 0;
        while (i != this.safeBagSeq.size()) {
            safeBags[i] = new PKCS12SafeBag(SafeBag.getInstance(this.safeBagSeq.getObjectAt(i)));
            ++i;
        }
        return safeBags;
    }
}

